<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AgricultureActivity;
use App\Models\Crop;
use App\Models\CropCultivation;
use App\Models\Farmer;
use App\Models\CaphFarm;
use App\Models\TrdFarm;
use App\Models\VaOneFarm;
use App\Models\VaTwoFarm;
use App\Models\VaThreeFarm;
use DB;
use App\Models\FarmMechanism;
use App\Models\IrrigationInfrastructure;
use App\Models\LastYearProduction;
use App\Models\OtherInfrastructure;
use App\Models\ProcessingInfrastructure;
use App\Models\ProductionOutput;
use App\Models\RetailOutlet;
use App\Models\StorageStructure;
use App\Models\InputSupplier;
use App\Models\User;
use App\Models\InputSuppler;
use App\Models\ForwardLinkage;
use App\Models\BackwardLinkage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Schema;
use App\Models\economic_life_farm_assets_master;
use App\Models\investment_plantation;
use Illuminate\Support\Facades\Session;
use App\Models\BackwardLinkageTwo;

class AnexureController extends Controller
{
    
    public function updateAnnexureOneStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'crop_id'   => $id,
            'status'    => $status
        ], [
            'crop_id'   =>  'required|exists:crops,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.one',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            Crop::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.one',['date' => $date])->with('success','Annexure Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function one_list(Request $request)
    {
        
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        $current_user_role_id = $userAuth['role_id'];
       
        try {
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
           
           
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            // $query = DB::table('crops')->select(
            //     'crops.*',
            //     'users.team_leader_id',
            //     'users.village as user_village',
            //     'users.role_id',
            //     'users.farmer_code_id as farmer_code',
            //     'users.first_name as farmer_first_name',
            //     'users.last_name as farmer_last_name',
            //     'users.husband_father_name as farmer_husband_father_name',
            //     'states.state_name as farmer_state_name',
            //     'districts.district_name as farmer_district_name',
            //     'users.block as farmer_block',
            //     'users.mobile_number as farmer_mobile_number',
            //     'farmers.id as farmerId',
            //     'farmers.*',
            //     'crops.crop_area as crop_areas',
            //     'crop_cultivations.*',
            //     'production_outputs.*',
            //     'production_outputs.other as production_outputs_other',
            //     'irrigation_infrastructures.*',
            //     'irrigation_infrastructures.other as irrigation_infrastructures_other',
            //     'farm_mechanisms.*',
            //     'farm_mechanisms.other as farm_mechanisms_other',
            //     'storage_structures.*',
            //     'storage_structures.other as storage_structures_other',
            //     'processing_infrastructures.*',
            //     'retail_outlets.*',
            //     'other_infrastructures.*',
            //     'crops.id as id',
            //     'crops.user_id as user_id'
            // )
            // ->leftJoin('users','users.id','=','crops.user_id')
            // //->leftJoin('users as farmers','farmers.id','=','crops.farmer_id')
            // ->leftJoin('states', 'states.id', '=', 'users.state_id')
            // ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
            // // ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
            // ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
            // ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
            // ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
            // ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
            // ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
            // ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
            // ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
            // ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
            // ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id')
            // ->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
            //     if ($current_user_role_id == 41 || $current_user_role_id == 45 || $current_user_role_id == 47 || $current_user_role_id == 48) {
            //         return $query;
            //     }
            //     return $query->where(function ($query) use ($user_id) {
            //         $query->where('users.team_leader_id', $user_id)
            //               ->orWhere('users.id', $user_id);
            //     });
            // });
            
             $query = DB::table('crops')->select(
                'crops.*',
                'users.team_leader_id',
                'users.village as user_village',
                'users.role_id',
                'users.farmer_code_id as farmer_code',
                'users.first_name as farmer_first_name',
                'users.last_name as farmer_last_name',
                'users.husband_father_name as farmer_husband_father_name',
                'states.state_name as farmer_state_name',
                'districts.district_name as farmer_district_name',
                'users.block as farmer_block',
                'users.mobile_number as farmer_mobile_number',
                'farmers.id as farmerId',
                'farmers.*',
                'crops.crop_area as crop_areas',
                'crop_cultivations.*',
                'production_outputs.*',
                'production_outputs.other as production_outputs_other',
                'crops.id as id',
                'crops.user_id as user_id'
            )
            ->leftJoin('users','users.id','=','crops.user_id')
            //->leftJoin('users as farmers','farmers.id','=','crops.farmer_id')
            ->leftJoin('states', 'states.id', '=', 'users.state_id')
            ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
            // ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
            ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
            ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
            ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
            ->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
                if ($current_user_role_id == 41 || $current_user_role_id == 45 || $current_user_role_id == 47 || $current_user_role_id == 48) {
                    return $query;
                }
                return $query->where(function ($query) use ($user_id) {
                    $query->where('users.team_leader_id', $user_id)
                          ->orWhere('users.id', $user_id);
                });
            });
            
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $query->whereDate('crops.created_at', '=', $startDate);
                    $query->whereDate('farmers.created_at', '=', $startDate);
                } else {
                    // $query->whereBetween('crops.created_at', [$startDate, $endDate]);
                  $query->whereDate('crops.created_at', '>=', $startDate);
                  $query->whereDate('farmers.created_at', '>=', $startDate);
                  $query->whereDate('crops.created_at', '<=', $endDate);
                  $query->whereDate('farmers.created_at', '<=', $endDate);
                }
                
                
                
            } elseif ($startDate) {
                $query->whereDate('crops.created_at', '>=', $startDate);
                $query->whereDate('farmers.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $query->whereDate('crops.created_at', '<=', $endDate);
                $query->whereDate('farmers.created_at', '<=', $endDate);
            } else {
                $query->whereDate('crops.created_at', '=', now()->toDateString());
                $query->whereDate('farmers.created_at', '=', now()->toDateString());
            }
           
            $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
          
            $deshboard = 2;
            return view('Anexure.anexure-one', ['data' => $data,'deshboard'=>$deshboard]);
            
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    // 06/11/2024
    // public function anexureOneUpdate(Request $request)
    // {
    //     $userAuth = Auth::user();
    //     $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
    //     $current_user_role_id = $userAuth['role_id'];
        
    //     try {
    //         if ($request->isMethod('post')) 
    //         {   
    //             dd($request->all());
    //             dd('data change');
    //             dd($request->all());
    //             // $id = $request->input('vc');
    //             $id = $request->input('data_id');
    //             $farmerId = $request->input('farmer_id');
    //             $getCrop = Crop::find($id);
    //             // print_r($_POST);
    //             dd($request->input());
    //             $crop = [
    //                 'season' => $request->input("season_$id"."_"."$farmerId"),
    //                 'crop_name' => $request->input("crop_name_$id"."_"."$farmerId"),
    //                 'crop_area_unit' => $request->input("crop_area_unit_$id"."_"."$farmerId"),
    //                 'crop_area' => $request->input("crop_area_$$id"."_"."$farmerId"),
    //                 'irrigated_area' => $request->input("irrigated_area_$id"."_"."$farmerId"),
    //             ];
                
    //             $cropCultivation = [
    //                 'family_labour_hrs' => $request->input("family_labour_hrs_$id"."_"."$farmerId"),
    //                 'family_labour_unit_price' => $request->input("family_labour_unit_price_$id"."_"."$farmerId"),
    //                 'family_labour_rs' => $request->input("family_labour_rs_$id"."_"."$farmerId"),
    //                 'family_labour_remarks' => $request->input("family_labour_remarks_$id"."_"."$farmerId"),
    //                 'attached_labour_unit' => $request->input("attached_labour_unit_$id"."_"."$farmerId"),
    //                 'attached_labour_hrs' => $request->input("attached_labour_hrs_$id"."_"."$farmerId"),
    //                 'attached_labour_unit_price' => $request->input("attached_labour_unit_price_$id"."_"."$farmerId"),
    //                 'attached_labour_rs' => $request->input("attached_labour_rs_$id"."_"."$farmerId"),
    //                 'attached_labour_remarks' => $request->input("attached_labour_remarks_$id"."_"."$farmerId"),
    //                 'casual_labour_unit' => $request->input("casual_labour_unit_$id"."_"."$farmerId"),
    //                 'casual_labour_rs' => $request->input("casual_labour_rs_$id"."_"."$farmerId"),
    //                 'casual_labour_unit_price' => $request->input("casual_labour_unit_price_$id"."_"."$farmerId"),
    //                 'casual_labour_hrs' => $request->input("casual_labour_hrs_$id"."_"."$farmerId"),
    //                 'casual_labour_remarks' => $request->input("casual_labour_remarks_$id"."_"."$farmerId"),
    //                 'hired_animal_unit' => $request->input("hired_animal_unit_$id"."_"."$farmerId"),
    //                 'hired_animal_labour_rs' => $request->input("hired_animal_labour_rs_$id"."_"."$farmerId"),
    //                 'hired_animal_unit_price' => $request->input("hired_animal_unit_price_$id"."_"."$farmerId"),
    //                 'hired_animal_labour_hrs' => $request->input("hired_animal_labour_hrs_$id"."_"."$farmerId"),
    //                 'hired_animal_remarks' => $request->input("hired_animal_remarks_$id"."_"."$farmerId"),
    //                 'owned_animal_unit' => $request->input("owned_animal_unit_$id"."_"."$farmerId"),
    //                 'owned_animal_hrs' => $request->input("owned_animal_hrs_$id"."_"."$farmerId"),
    //                 'owned_animal_unit_price' => $request->input("owned_animal_unit_price_$id"."_"."$farmerId"),
    //                 'owned_animal_rs' => $request->input("owned_animal_rs_$id"."_"."$farmerId"),
    //                 'owned_animal_remarks' => $request->input("owned_animal_remarks_$id"."_"."$farmerId"),
    //                 'hired_machhine_hrs' => $request->input("hired_machhine_hrs_$id"."_"."$farmerId"),
    //                 'hired_machhine_unit_price' => $request->input("hired_machhine_unit_price_$id"."_"."$farmerId"),
    //                 'hired_machhine_rs' => $request->input("hired_machhine_rs_$id"."_"."$farmerId"),
    //                 'hired_machhine_remarks' => $request->input("hired_machhine_remarks_$id"."_"."$farmerId"),
    //                 'own_machine_unit' => $request->input("own_machine_unit_$id"."_"."$farmerId"),
    //                 'own_machine_rs' => $request->input("own_machine_rs_$id"."_"."$farmerId"),
    //                 'own_machine_unit_price' => $request->input("own_machine_unit_price_$id"."_"."$farmerId"),
    //                 'own_machine_hrs' => $request->input("own_machine_hrs_$id"."_"."$farmerId"),
    //                 'own_machine_remarks' => $request->input("own_machine_remarks_$id"."_"."$farmerId"),
    //                 'hired_irrigation_machine_unit' => $request->input("hired_irrigation_machine_unit_$id"."_"."$farmerId"),
    //                 'hired_irrigation_machine_hrs' => $request->input("hired_irrigation_machine_hrs_$id"."_"."$farmerId"),
    //                 'hired_irrigation_machine_unit_price' => $request->input("hired_irrigation_machine_unit_price_$id"."_"."$farmerId"),
    //                 'hired_irrigation_machine_rs' => $request->input("hired_irrigation_machine_rs_$id"."_"."$farmerId"),
    //                 'hired_irrigation_machine_remarks' => $request->input("hired_irrigation_machine_remarks_$id"."_"."$farmerId"),
    //                 'owned_irrigation_machine_unit' => $request->input("owned_irrigation_machine_unit_$id"."_"."$farmerId"),
    //                 'owned_irrigation_machine_hrs' => $request->input("owned_irrigation_machine_hrs_$id"."_"."$farmerId"),
    //                 'owned_irrigation_machine_unit_price' => $request->input("owned_irrigation_machine_unit_price_$id"."_"."$farmerId"),
    //                 'owned_irrigation_machine_rs' => $request->input("owned_irrigation_machine_rs_$id"."_"."$farmerId"),
    //                 'owned_irrigation_machine_remarks' => $request->input("owned_irrigation_machine_remarks_$id"."_"."$farmerId"),
    //                 'seed_type' => $request->input("seed_type_$id"."_"."$farmerId"),
    //                 'seed_variety' => $request->input("seed_variety_$id"."_"."$farmerId"),
    //                 'seed_qty_unit' => $request->input("seed_qty_unit_$id"."_"."$farmerId"),
    //                 'seed_qty' => $request->input("seed_qty_$id"."_"."$farmerId"),
    //                 'seed_unit_price' => $request->input("seed_unit_price_$id"."_"."$farmerId"),
    //                 'seed_value_rs' => $request->input("seed_value_rs_$id"."_"."$farmerId"),
    //                 'seed_remarks' => $request->input("seed_remarks_$id"."_"."$farmerId"),
    //                 'fertiliser_n_qty_unit' => $request->input("fertiliser_n_qty_unit_$id"."_"."$farmerId"),
    //                 'fertiliser_n_qty' => $request->input("fertiliser_n_qty_$id"."_"."$farmerId"),
    //                 'fertiliser_n_unit_price' => $request->input("fertiliser_n_unit_price_$id"."_"."$farmerId"),
    //                 'fertiliser_n_rs' => $request->input("fertiliser_n_rs_$id"."_"."$farmerId"),
    //                 'fertiliser_n_remarks' => $request->input("fertiliser_n_remarks_$id"."_"."$farmerId"),
    //                 'fertiliser_p_qty_unit' => $request->input("fertiliser_p_qty_unit_$id"."_"."$farmerId"),
    //                 'fertiliser_p_qty' => $request->input("fertiliser_p_qty_$id"."_"."$farmerId"),
    //                 'fertiliser_p_unit_price' => $request->input("fertiliser_p_unit_price_$id"."_"."$farmerId"),
    //                 'fertiliser_p_rs' => $request->input("fertiliser_p_rs_$id"."_"."$farmerId"),
    //                 'fertiliser_p_remarks' => $request->input("fertiliser_p_remarks_$id"."_"."$farmerId"),
    //                 'fertiliser_k_qty_unit' => $request->input("fertiliser_k_qty_unit_$id"."_"."$farmerId"),
    //                 'fertiliser_k_qty' => $request->input("fertiliser_k_qty_$id"."_"."$farmerId"),
    //                 'fertiliser_k_unit_price' => $request->input("fertiliser_k_unit_price_$id"."_"."$farmerId"),
    //                 'fertiliser_k_rs' => $request->input("fertiliser_k_rs_$id"."_"."$farmerId"),
    //                 'fertiliser_k_remarks' => $request->input("fertiliser_k_remarks_$id"."_"."$farmerId"),
    //                 'other_fertiliser_qty_unit' => $request->input("other_fertiliser_qty_unit_$id"."_"."$farmerId"),
    //                 'other_fertiliser_qty' => $request->input("other_fertiliser_qty_$id"."_"."$farmerId"),
    //                 'other_fertiliser_unit_price' => $request->input("other_fertiliser_unit_price_$id"."_"."$farmerId"),
    //                 'other_fertiliser_rs' => $request->input("other_fertiliser_rs_$id"."_"."$farmerId"),
    //                 'other_fertiliser_remarks' => $request->input("other_fertiliser_remarks_$id"."_"."$farmerId"),
    //                 'other_irrigation_charges_hrs' => $request->input("other_irrigation_charges_hrs_$id"."_"."$farmerId"),
    //                 'dap_qty_unit' => $request->input("dap_qty_unit_$id"."_"."$farmerId"),
    //                 'dap_qty' => $request->input("dap_qty_$id"."_"."$farmerId"),
    //                 'dap_unit_price' => $request->input("dap_unit_price_$id"."_"."$farmerId"),
    //                 'dap_rs' => $request->input("dap_rs_$id"."_"."$farmerId"),
    //                 'dap_remarks' => $request->input("dap_remarks_$id"."_"."$farmerId"),
    //                 // 'dap_kg' => $request->input("dap_kg_$id"."_"."$farmerId"),
    //                 'npk_qty_unit' => $request->input("npk_qty_unit_$id"."_"."$farmerId"),
    //                 'npk_qty' => $request->input("npk_qty_$id"."_"."$farmerId"),
    //                 'npk_unit_price' => $request->input("npk_unit_price_$id"."_"."$farmerId"),
    //                 'npk_rs' => $request->input("npk_rs_$id"."_"."$farmerId"),
    //                 'npk_remarks' => $request->input("npk_remarks_$id"."_"."$farmerId"),
    //                 // 'npk_kg' => $request->input("npk_kg_$id"."_"."$farmerId"),
    //                 'manure_qty_unit' => $request->input("manure_qty_unit_$id"."_"."$farmerId"),
    //                 'manure_qty' => $request->input("manure_qty_$id"."_"."$farmerId"),
    //                 'manure_unit_price' => $request->input("manure_unit_price_$id"."_"."$farmerId"),
    //                 // 'manure_qtl' => $request->input("manure_qtl_$id"."_"."$farmerId"),
    //                 'manure_rs' => $request->input("manure_rs_$id"."_"."$farmerId"),
    //                 'manure_remarks' => $request->input("manure_remarks_$id"."_"."$farmerId"),
    //                 'insecticide_unit' => $request->input("insecticide_unit_$id"."_"."$farmerId"),
    //                 'insticide_name' => $request->input("insticide_name_$id"."_"."$farmerId"),
    //                 'insecticide_qty' => $request->input("insecticide_qty_$id"."_"."$farmerId"),
    //                 'insecticide_unit_price' => $request->input("insecticide_unit_price_$id"."_"."$farmerId"),
    //                 'insecticide_rs' => $request->input("insecticide_rs_$id"."_"."$farmerId"),
    //                 'insecticide_remarks' => $request->input("insecticide_remarks_$id"."_"."$farmerId"),
    //                 'canal_other_charges' => $request->input("canal_other_charges_$id"."_"."$farmerId"),
    //                 'crop_insurance_rs' => $request->input("crop_insurance_rs_$id"."_"."$farmerId"),
    //                 'miscelaneous_cost_rs' => $request->input("miscelaneous_cost_rs_$id"."_"."$farmerId"),
    //                 'land_revenue_rs' => $request->input("land_revenue_rs_$id"."_"."$farmerId"),
    //                 'rent_paid_leased_land' => $request->input("rent_paid_leased_land_$id"."_"."$farmerId"),
    //                 'interest_kcc' => $request->input("interest_kcc_$id"."_"."$farmerId")
    //             ];
                
                
                
    //             $farmerData = [
    //                 'kcc_limit' => $request->input("kcc_limit_$id"."_"."$farmerId"),
    //                 'land_type' => $request->input("land_type_$id"."_"."$farmerId"),
    //                 'soil_health_card' => $request->input("soil_health_card_$id"."_"."$farmerId"),
    //                 'soil_health_card_remark' => $request->input("soil_health_card_remark_$id"."_"."$farmerId"),
    //                 'land_holding_size_unit' => $request->input("land_holding_size_unit_$id"."_"."$farmerId"),
    //                 'land_holding_size' => $request->input("land_holding_size_$id"."_"."$farmerId"),
    //                 'land_given_lease_unit' => $request->input("land_holding_size_$id"."_"."$farmerId"),
    //                 'land_given_lease' => $request->input("land_given_lease_$id"."_"."$farmerId"),
    //                 'land_holding_taken_lease_unit' => $request->input("land_holding_taken_lease_unit_$id"."_"."$farmerId"),
    //                 'land_holding_taken_lease' => $request->input("land_holding_taken_lease_$id"."_"."$farmerId"),
    //                 'total_cultivable_unit' => $request->input("total_cultivable_unit_$id"."_"."$farmerId"),
    //                 'total_cultivable' => $request->input("total_cultivable_$id"."_"."$farmerId"),
    //             ];
    //             // dd($farmerData);
    //             $outputProduction = [
    //                 'total_production' => $request->input("total_production_$id"."_"."$farmerId"),
    //                 'sold_main_product' => $request->input("sold_main_product_$id"."_"."$farmerId"),
    //                 'selling_price_main_product' => $request->input("selling_price_main_product_$id"."_"."$farmerId"),
    //                 'by_product' => $request->input("by_product_$id"."_"."$farmerId"),
    //                 'selling_price_by_product' => $request->input("selling_price_by_product_$id"."_"."$farmerId"),
    //                 'village_trader' => $request->input("village_trader_$id"."_"."$farmerId"),
    //                 'wholesaler' => $request->input("wholesaler_$id"."_"."$farmerId"),
    //                 'mandi' => $request->input("mandi_$id"."_"."$farmerId"),
    //                 'processor' => $request->input("processor_$id"."_"."$farmerId"),
    //                 'retailer' => $request->input("retailer_$id"."_"."$farmerId"),
    //                 'consumer' => $request->input("consumer_$id"."_"."$farmerId"),
                    
    //                 'minimum_price' => $request->input("minimum_price_$id"."_"."$farmerId"),
    //                 'maximum_price' => $request->input("maximum_price_$id"."_"."$farmerId"),
    //                 'minimum_price_unit' => $request->input("minimum_price_unit_$id"."_"."$farmerId"),
    //                 'maximum_price_unit' => $request->input("maximum_price_unit_$id"."_"."$farmerId"),
    //             ];
                
    //             $irrigationInfrastructure = [
    //                 'canal' => $request->input("canal_$id"."_"."$farmerId"),
    //                 'tubewell' => $request->input("tubewell_$id"."_"."$farmerId"),
    //                 'enginer_motor_solar' => $request->input("enginer_motor_solar_$id"."_"."$farmerId"),
    //                 'pump_sets' => $request->input("pump_sets_$id"."_"."$farmerId"),
    //                 'pond' => $request->input("pond_$id"."_"."$farmerId"),
    //                 'irrigation_system' => $request->input("irrigation_system_$id"."_"."$farmerId"),
    //                 'enginer_motor_solar' => $request->input("enginer_motor_solar_$id"."_"."$farmerId"),
    //                 'other' => $request->input("irrigation_infrastructure_other_$id"."_"."$farmerId")
    //             ];
                
                
    //              foreach($irrigationInfrastructure as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $irrigationInfrastructure[$key] = json_encode($data);
    //              }
                 
    //             // dd($irrigationInfrastructure);
    //             // die;
                
                
    //             $farmMechanisms = [
    //                   'tractor' => $request->input("tractor_$id"."_"."$farmerId"),
    //                   'power_tiller' => $request->input("power_tiller_$id"."_"."$farmerId"),
    //                   'cultivator' => $request->input("cultivator_$id"."_"."$farmerId"),
    //                   'rotator' => $request->input("rotator_$id"."_"."$farmerId"),
    //                   'harrow' => $request->input("harrow_$id"."_"."$farmerId"),
    //                   'leveller' => $request->input("leveller_$id"."_"."$farmerId"),
    //                   'plough' => $request->input("plough_$id"."_"."$farmerId"),
    //                   'speed_drill' => $request->input("speed_drill_$id"."_"."$farmerId"),
    //                   'speed_planter' => $request->input("speed_planter_$id"."_"."$farmerId"),
    //                   'speed_cum_fertilizer_drill' => $request->input("speed_cum_fertilizer_drill_$id"."_"."$farmerId"),
    //                   'trolley' => $request->input("trolley_$id"."_"."$farmerId"),
    //                   'reaper_cum_binder' => $request->input("reaper_cum_binder_$id"."_"."$farmerId"),
    //                   'bhusa_machine' => $request->input("bhusa_machine_$id"."_"."$farmerId"),
    //                   'thresher' => $request->input("thresher_$id"."_"."$farmerId"),
    //                   'combine_harvester' => $request->input("combine_harvester_$id"."_"."$farmerId"),
    //                   'other' => $request->input("farm_mechanisms_other_$id"."_"."$farmerId"),
    //             ];
                
    //             foreach($farmMechanisms as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $farmMechanisms[$key] = json_encode($data);
    //             }
                
                
                
    //             $storageStructure = [
    //                 'deshi' => $request->input("deshi_$id"."_"."$farmerId"),
    //                 'godown' => $request->input("godown_$id"."_"."$farmerId"),
    //                 'clod' => $request->input("clod_$id"."_"."$farmerId"),
    //                 'bulk_cooling' => $request->input("bulk_cooling_$id"."_"."$farmerId"),
    //                 'fodder' => $request->input("fodder_$id"."_"."$farmerId")
    //             ];
                
    //             foreach($storageStructure as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $storageStructure[$key] = json_encode($data);
    //             }
                
    //             $processingInfrstructure = [
    //                 'wheat_processing' => $request->input("wheat_processing_$id"."_"."$farmerId"),
    //                 'oil_processing' => $request->input("oil_processing_$id"."_"."$farmerId"),
    //                 'sugarcane_processing' => $request->input("sugarcane_processing_$id"."_"."$farmerId"),
    //                 'dal_processing' => $request->input("dal_processing_$id"."_"."$farmerId"),
    //                 'other_processing' => $request->input("other_processing_$id"."_"."$farmerId"),
    //             ];
                
    //             foreach($processingInfrstructure as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $processingInfrstructure[$key] = json_encode($data);
    //             }
                
    //             $retailOutlets = [
    //                 'kiran_outlets' => $request->input("kiran_outlets_$id"."_"."$farmerId"),
    //                 'grossary_outlets' => $request->input("grossary_outlets_$id"."_"."$farmerId"),
    //                 'other_outlets' => $request->input("other_outlets_$id"."_"."$farmerId"),
    //             ];
                
    //             foreach($retailOutlets as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $retailOutlets[$key] = json_encode($data);
    //             }
                
    //             $otherInfrastructures = [
    //                 'shed_kuchha' => $request->input("shed_kuchha_$id"."_"."$farmerId"),
    //                 'shed_pucca' => $request->input("shed_pucca_$id"."_"."$farmerId"),
    //                 'other_infrastructure' => $request->input("other_infrastructure_$id"."_"."$farmerId"),
    //             ];
                
                
    //             foreach($otherInfrastructures as $key=>$val){
    //                     $data['number']=$request->input($key."_number_".$id."_".$farmerId);
    //                     $data['specification']=$request->input($key."_specification_".$id."_".$farmerId);
    //                     $data['year_of_asset_creation']=$request->input($key."_year_of_asset_creation_".$id."_".$farmerId);
    //                     $data['total_investment_cost'] = $request->input($key."_total_investment_cost_" .$id."_".$farmerId);
    //                     $data['subsidy_grant'] = $request->input($key."_subsidy_grant_" .$id."_".$farmerId);
    //                     $data['bank_loan_cost'] = $request->input($key."_bank_loan_cost_" .$id."_".$farmerId);
    //                     $data['balance_source_of_investment'] = $request->input($key."_balance_source_of_investment_" .$id."_".$farmerId);
    //                     $data['economic_useful_life'] = $request->input($key."_economic_useful_life_" .$id."_".$farmerId);
    //                     $data['residual_value_of_asset'] = $request->input($key."_residual_value_of_asset_" .$id."_".$farmerId);
    //                     $data['annual_interest_on_bank_loan'] = $request->input($key."_annual_interest_on_bank_loan_" .$id."_".$farmerId);
    //                     $data['annual_depreciation'] = $request->input($key."_annual_depreciation_" .$id."_".$farmerId);
    //                     $data['annual_insurance'] = $request->input($key."_annual_insurance_" .$id."_".$farmerId);
    //                     $data['annual_tax'] = $request->input($key."_annual_tax_" .$id."_".$farmerId);
    //                     $data['annual_repair_and_maintenance'] = $request->input($key."_annual_repair_and_maintenance_" .$id."_".$farmerId);
    //                     $data['annual_fixed_cost_of_asset'] = $request->input($key."_annual_fixed_cost_of_asset_" .$id."_".$farmerId);
    //                     $data['any_other'] = $request->input($key."_any_other_" .$id."_".$farmerId);
    //                     $otherInfrastructures[$key] = json_encode($data);
    //             }
              
           

             

                
    //             if ($id && !empty($crop)) {
    //                 DB::table('crops')->where('id', $id)->update($crop);
    //             }
                
    //             if ($id && !empty($cropCultivation)) {
    //                 DB::table('crop_cultivations')->where('crop_id', $id)->update($cropCultivation);
    //             }
                
    //             if ($id && !empty($outputProduction)) {
    //                 DB::table('production_outputs')->where('crop_id', $id)->update($outputProduction);
    //             }
                
    //             if ($id && !empty($irrigationInfrastructure)) {
    //                 DB::table('irrigation_infrastructures')->where('crop_id', $id)->update($irrigationInfrastructure);
    //             }
                
    //             if ($id && !empty($farmMechanisms)) {
    //                 DB::table('farm_mechanisms')->where('crop_id', $id)->update($farmMechanisms);
    //             }
                
    //             if ($id && !empty($storageStructure)) {
    //                 DB::table('storage_structures')->where('crop_id', $id)->update($storageStructure);
    //             }
                
    //             if ($id && !empty($processingInfrstructure)) {
    //                 DB::table('processing_infrastructures')->where('crop_id', $id)->update($processingInfrstructure);
    //             }
                
    //             if ($id && !empty($retailOutlets)) {
    //                 DB::table('retail_outlets')->where('crop_id', $id)->update($retailOutlets);
    //             }
                
    //             if ($id && !empty($otherInfrastructures)) {
    //                 DB::table('other_infrastructures')->where('crop_id', $id)->update($otherInfrastructures);
    //             }
                
    //             if ($id && !empty($farmerData)) {
    //                 // $farmerUpdatedData = DB::table('users')->where('users.id', $getCrop->farmer_id)->update($farmerData);
    //                 $farmerUpdatedData = DB::table('farmers')->where('farmers.id', $farmerId)->update($farmerData);
    //             }
    //         }
            
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
    
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
    
    //         $query = DB::table('crops')->select(
    //             'crops.*',
    //             'users.team_leader_id',
    //             'users.village as user_village',
    //             'users.role_id',
    //             'users.farmer_code_id as farmer_code',
    //             'users.first_name as farmer_first_name',
    //             'users.last_name as farmer_last_name',
    //             'users.husband_father_name as farmer_husband_father_name',
    //             'states.state_name as farmer_state_name',
    //             'districts.district_name as farmer_district_name',
    //             'users.block as farmer_block',
    //             'users.mobile_number as farmer_mobile_number',
    //             'farmers.id as farmerId',
    //             'farmers.*',
    //             'crops.crop_area as crop_areas',
    //             'crop_cultivations.*',
    //             'production_outputs.*',
    //             'production_outputs.other as production_outputs_other',
    //             'irrigation_infrastructures.*',
    //             'irrigation_infrastructures.other as irrigation_infrastructures_other',
    //             'farm_mechanisms.*',
    //             'farm_mechanisms.other as farm_mechanisms_other',
    //             'storage_structures.*',
    //             'storage_structures.other as storage_structures_other',
    //             'processing_infrastructures.*',
    //             'retail_outlets.*',
    //             'other_infrastructures.*',
    //             'crops.id as id'
    //         )
    //         ->leftJoin('users','users.id','=','crops.user_id')
    //         // ->leftJoin('users as farmers','farmers.id','=','crops.farmer_id')
    //         ->leftJoin('states', 'states.id', '=', 'users.state_id')
    //         ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
    //         // ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
    //         ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
    //         ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
    //         ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
    //         ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
    //         ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
    //         ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
    //         ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
    //         ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
    //         ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id')
    //         ->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
    //             if ($current_user_role_id == 41 || $current_user_role_id == 45 || $current_user_role_id == 47 || $current_user_role_id == 48) {
    //                 return $query;
    //             }
    //             return $query->where(function ($query) use ($user_id) {
    //                 $query->where('users.team_leader_id', $user_id)
    //                       ->orWhere('users.id', $user_id);
    //             });
    //         });
                
    //         if ($startDate && $endDate) {
    //             if ($startDate->eq($endDate)) {
    //                 $query->whereDate('crops.created_at', '=', $startDate);
    //             } else {
    //                 // $query->whereBetween('crops.created_at', [$startDate, $endDate]);
    //                 $query->whereDate('crops.created_at', '>=', $startDate);
    //                 $query->whereDate('farmers.created_at', '>=', $startDate);
    //                 $query->whereDate('crops.created_at', '<=', $endDate);
    //                 $query->whereDate('farmers.created_at', '<=', $endDate);
    //             }
    //         } elseif ($startDate) {
    //             $query->whereDate('crops.created_at', '>=', $startDate);
    //             $query->whereDate('farmers.created_at', '>=', $startDate);
    //         } elseif ($endDate) {
    //             $query->whereDate('crops.created_at', '<=', $endDate);
    //             $query->whereDate('farmers.created_at', '<=', $endDate);
    //         } else {
    //             $query->whereDate('crops.created_at', '=', now()->toDateString());
    //             $query->whereDate('farmers.created_at', '=', now()->toDateString());
    //         }
            
    
    //         $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
    //         // echo "<pre>";
    //         // print_r($data); die;
    //         // $sql = $query->toSql();
    //         // print_r($sql);die();
            
    //         return view('Anexure.anexure-one-update', [
    //             'data' => $data
    //         ]);
    
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    
    
     public function anexureOneUpdate(Request $request)
     {
        
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        $current_user_role_id = $userAuth['role_id'];
        
        try {
            if ($request->isMethod('post')) 
            {   

                // $id = $request->input('vc');
                
                $id = $request->input('data_id');
                $farmerId = $request->input('farmer_id');
                $getCrop = Crop::find($id);
                // print_r($_POST);
                // dd($request->input());
                $crop = [
                    'season' => $request->input("season_$id"."_"."$farmerId"),
                    'crop_name' => $request->input("crop_name_$id"."_"."$farmerId"),
                    'crop_area_unit' => $request->input("crop_area_unit_$id"."_"."$farmerId"),
                    'crop_area' => $request->input("crop_area_$$id"."_"."$farmerId"),
                    'irrigated_area' => $request->input("irrigated_area_$id"."_"."$farmerId"),
                ];
                
                $cropCultivation = [
                    'family_labour_hrs' => $request->input("family_labour_hrs_$id"."_"."$farmerId"),
                    'family_labour_unit_price' => $request->input("family_labour_unit_price_$id"."_"."$farmerId"),
                    'family_labour_rs' => $request->input("family_labour_rs_$id"."_"."$farmerId"),
                    'family_labour_remarks' => $request->input("family_labour_remarks_$id"."_"."$farmerId"),
                    'attached_labour_unit' => $request->input("attached_labour_unit_$id"."_"."$farmerId"),
                    'attached_labour_hrs' => $request->input("attached_labour_hrs_$id"."_"."$farmerId"),
                    'attached_labour_unit_price' => $request->input("attached_labour_unit_price_$id"."_"."$farmerId"),
                    'attached_labour_rs' => $request->input("attached_labour_rs_$id"."_"."$farmerId"),
                    'attached_labour_remarks' => $request->input("attached_labour_remarks_$id"."_"."$farmerId"),
                    'casual_labour_unit' => $request->input("casual_labour_unit_$id"."_"."$farmerId"),
                    'casual_labour_rs' => $request->input("casual_labour_rs_$id"."_"."$farmerId"),
                    'casual_labour_unit_price' => $request->input("casual_labour_unit_price_$id"."_"."$farmerId"),
                    'casual_labour_hrs' => $request->input("casual_labour_hrs_$id"."_"."$farmerId"),
                    'casual_labour_remarks' => $request->input("casual_labour_remarks_$id"."_"."$farmerId"),
                    'hired_animal_unit' => $request->input("hired_animal_unit_$id"."_"."$farmerId"),
                    'hired_animal_labour_rs' => $request->input("hired_animal_labour_rs_$id"."_"."$farmerId"),
                    'hired_animal_unit_price' => $request->input("hired_animal_unit_price_$id"."_"."$farmerId"),
                    'hired_animal_labour_hrs' => $request->input("hired_animal_labour_hrs_$id"."_"."$farmerId"),
                    'hired_animal_remarks' => $request->input("hired_animal_remarks_$id"."_"."$farmerId"),
                    'owned_animal_unit' => $request->input("owned_animal_unit_$id"."_"."$farmerId"),
                    'owned_animal_hrs' => $request->input("owned_animal_hrs_$id"."_"."$farmerId"),
                    'owned_animal_unit_price' => $request->input("owned_animal_unit_price_$id"."_"."$farmerId"),
                    'owned_animal_rs' => $request->input("owned_animal_rs_$id"."_"."$farmerId"),
                    'owned_animal_remarks' => $request->input("owned_animal_remarks_$id"."_"."$farmerId"),
                    'hired_machhine_hrs' => $request->input("hired_machhine_hrs_$id"."_"."$farmerId"),
                    'hired_machhine_unit_price' => $request->input("hired_machhine_unit_price_$id"."_"."$farmerId"),
                    'hired_machhine_rs' => $request->input("hired_machhine_rs_$id"."_"."$farmerId"),
                    'hired_machhine_remarks' => $request->input("hired_machhine_remarks_$id"."_"."$farmerId"),
                    'own_machine_unit' => $request->input("own_machine_unit_$id"."_"."$farmerId"),
                    'own_machine_rs' => $request->input("own_machine_rs_$id"."_"."$farmerId"),
                    'own_machine_unit_price' => $request->input("own_machine_unit_price_$id"."_"."$farmerId"),
                    'own_machine_hrs' => $request->input("own_machine_hrs_$id"."_"."$farmerId"),
                    'own_machine_remarks' => $request->input("own_machine_remarks_$id"."_"."$farmerId"),
                    'hired_irrigation_machine_unit' => $request->input("hired_irrigation_machine_unit_$id"."_"."$farmerId"),
                    'hired_irrigation_machine_hrs' => $request->input("hired_irrigation_machine_hrs_$id"."_"."$farmerId"),
                    'hired_irrigation_machine_unit_price' => $request->input("hired_irrigation_machine_unit_price_$id"."_"."$farmerId"),
                    'hired_irrigation_machine_rs' => $request->input("hired_irrigation_machine_rs_$id"."_"."$farmerId"),
                    'hired_irrigation_machine_remarks' => $request->input("hired_irrigation_machine_remarks_$id"."_"."$farmerId"),
                    'owned_irrigation_machine_unit' => $request->input("owned_irrigation_machine_unit_$id"."_"."$farmerId"),
                    'owned_irrigation_machine_hrs' => $request->input("owned_irrigation_machine_hrs_$id"."_"."$farmerId"),
                    'owned_irrigation_machine_unit_price' => $request->input("owned_irrigation_machine_unit_price_$id"."_"."$farmerId"),
                    'owned_irrigation_machine_rs' => $request->input("owned_irrigation_machine_rs_$id"."_"."$farmerId"),
                    'owned_irrigation_machine_remarks' => $request->input("owned_irrigation_machine_remarks_$id"."_"."$farmerId"),
                    'seed_type' => $request->input("seed_type_$id"."_"."$farmerId"),
                    'seed_variety' => $request->input("seed_variety_$id"."_"."$farmerId"),
                    'seed_qty_unit' => $request->input("seed_qty_unit_$id"."_"."$farmerId"),
                    'seed_qty' => $request->input("seed_qty_$id"."_"."$farmerId"),
                    'seed_unit_price' => $request->input("seed_unit_price_$id"."_"."$farmerId"),
                    'seed_value_rs' => $request->input("seed_value_rs_$id"."_"."$farmerId"),
                    'seed_remarks' => $request->input("seed_remarks_$id"."_"."$farmerId"),
                    'fertiliser_n_qty_unit' => $request->input("fertiliser_n_qty_unit_$id"."_"."$farmerId"),
                    'fertiliser_n_qty' => $request->input("fertiliser_n_qty_$id"."_"."$farmerId"),
                    'fertiliser_n_unit_price' => $request->input("fertiliser_n_unit_price_$id"."_"."$farmerId"),
                    'fertiliser_n_rs' => $request->input("fertiliser_n_rs_$id"."_"."$farmerId"),
                    'fertiliser_n_remarks' => $request->input("fertiliser_n_remarks_$id"."_"."$farmerId"),
                    'fertiliser_p_qty_unit' => $request->input("fertiliser_p_qty_unit_$id"."_"."$farmerId"),
                    'fertiliser_p_qty' => $request->input("fertiliser_p_qty_$id"."_"."$farmerId"),
                    'fertiliser_p_unit_price' => $request->input("fertiliser_p_unit_price_$id"."_"."$farmerId"),
                    'fertiliser_p_rs' => $request->input("fertiliser_p_rs_$id"."_"."$farmerId"),
                    'fertiliser_p_remarks' => $request->input("fertiliser_p_remarks_$id"."_"."$farmerId"),
                    'fertiliser_k_qty_unit' => $request->input("fertiliser_k_qty_unit_$id"."_"."$farmerId"),
                    'fertiliser_k_qty' => $request->input("fertiliser_k_qty_$id"."_"."$farmerId"),
                    'fertiliser_k_unit_price' => $request->input("fertiliser_k_unit_price_$id"."_"."$farmerId"),
                    'fertiliser_k_rs' => $request->input("fertiliser_k_rs_$id"."_"."$farmerId"),
                    'fertiliser_k_remarks' => $request->input("fertiliser_k_remarks_$id"."_"."$farmerId"),
                    
                    'other_fertiliser_name' => array($request->input("other_fertiliser_name_$id"."_"."$farmerId")),
                    
                    'other_fertiliser_qty_unit' => array($request->input("other_fertiliser_qty_unit_$id"."_"."$farmerId")),
                    'other_fertiliser_qty' => array($request->input("other_fertiliser_qty_$id"."_"."$farmerId")),
                    'other_fertiliser_unit_price' => array($request->input("other_fertiliser_unit_price_$id"."_"."$farmerId")),
                    'other_fertiliser_rs' => array($request->input("other_fertiliser_rs_$id"."_"."$farmerId")),
                    
                    'other_fertiliser_remarks' => $request->input("other_fertiliser_remarks_$id"."_"."$farmerId"),
                    'other_irrigation_charges_hrs' => $request->input("other_irrigation_charges_hrs_$id"."_"."$farmerId"),
                    'dap_qty_unit' => $request->input("dap_qty_unit_$id"."_"."$farmerId"),
                    'dap_qty' => $request->input("dap_qty_$id"."_"."$farmerId"),
                    'dap_unit_price' => $request->input("dap_unit_price_$id"."_"."$farmerId"),
                    'dap_rs' => $request->input("dap_rs_$id"."_"."$farmerId"),
                    'dap_remarks' => $request->input("dap_remarks_$id"."_"."$farmerId"),
                    // 'dap_kg' => $request->input("dap_kg_$id"."_"."$farmerId"),
                    'npk_qty_unit' => $request->input("npk_qty_unit_$id"."_"."$farmerId"),
                    'npk_qty' => $request->input("npk_qty_$id"."_"."$farmerId"),
                    'npk_unit_price' => $request->input("npk_unit_price_$id"."_"."$farmerId"),
                    'npk_rs' => $request->input("npk_rs_$id"."_"."$farmerId"),
                    'npk_remarks' => $request->input("npk_remarks_$id"."_"."$farmerId"),
                    // 'npk_kg' => $request->input("npk_kg_$id"."_"."$farmerId"),
                    'manure_qty_unit' => $request->input("manure_qty_unit_$id"."_"."$farmerId"),
                    'manure_qty' => $request->input("manure_qty_$id"."_"."$farmerId"),
                    'manure_unit_price' => $request->input("manure_unit_price_$id"."_"."$farmerId"),
                    // 'manure_qtl' => $request->input("manure_qtl_$id"."_"."$farmerId"),
                    'manure_rs' => $request->input("manure_rs_$id"."_"."$farmerId"),
                    'manure_remarks' => $request->input("manure_remarks_$id"."_"."$farmerId"),
                    
                    'insecticide_unit' => array($request->input("insecticide_unit_$id"."_"."$farmerId")),
                    
                    
                    'insticide_name' => array($request->input("insticide_name_$id"."_"."$farmerId")),
                    'insecticide_qty' => array($request->input("insecticide_qty_$id"."_"."$farmerId")),
                    'insecticide_unit_price' => array($request->input("insecticide_unit_price_$id"."_"."$farmerId")),
                    'insecticide_rs' => array($request->input("insecticide_rs_$id"."_"."$farmerId")),
                    'insecticide_remarks' => array($request->input("insecticide_remarks_$id"."_"."$farmerId")),
                    
                    'canal_other_charges' => $request->input("canal_other_charges_$id"."_"."$farmerId"),
                    'crop_insurance_rs' => $request->input("crop_insurance_rs_$id"."_"."$farmerId"),
                    'miscelaneous_cost_rs' => $request->input("miscelaneous_cost_rs_$id"."_"."$farmerId"),
                    'land_revenue_rs' => $request->input("land_revenue_rs_$id"."_"."$farmerId"),
                    'rent_paid_leased_land' => $request->input("rent_paid_leased_land_$id"."_"."$farmerId"),
                    'interest_kcc' => $request->input("interest_kcc_$id"."_"."$farmerId"),
                    'other_fix_cost' => $request->input("other_fix_cost_$id"."_"."$farmerId"),
                ];
                
                
                
                $farmerData = [
                    'kcc_limit' => $request->input("kcc_limit_$id"."_"."$farmerId"),
                    'land_type' => $request->input("land_type_$id"."_"."$farmerId"),
                    'soil_health_card' => $request->input("soil_health_card_$id"."_"."$farmerId"),
                    'soil_health_card_remark' => $request->input("soil_health_card_remark_$id"."_"."$farmerId"),
                    'land_holding_size_unit' => $request->input("land_holding_size_unit_$id"."_"."$farmerId"),
                    'land_holding_size' => $request->input("land_holding_size_$id"."_"."$farmerId"),
                    'land_given_lease_unit' => $request->input("land_holding_size_$id"."_"."$farmerId"),
                    'land_given_lease' => $request->input("land_given_lease_$id"."_"."$farmerId"),
                    'land_holding_taken_lease_unit' => $request->input("land_holding_taken_lease_unit_$id"."_"."$farmerId"),
                    'land_holding_taken_lease' => $request->input("land_holding_taken_lease_$id"."_"."$farmerId"),
                    'total_cultivable_unit' => $request->input("total_cultivable_unit_$id"."_"."$farmerId"),
                    'total_cultivable' => $request->input("total_cultivable_$id"."_"."$farmerId"),
                ];
                
                $outputProduction = [
                    'total_production' => $request->input("total_production_$id"."_"."$farmerId"),
                    'sold_main_product' => $request->input("sold_main_product_$id"."_"."$farmerId"),
                    'selling_price_main_product' => $request->input("selling_price_main_product_$id"."_"."$farmerId"),
                    'by_product' => $request->input("by_product_$id"."_"."$farmerId"),
                    'selling_price_by_product' => $request->input("selling_price_by_product_$id"."_"."$farmerId"),
                    'village_trader' => $request->input("village_trader_$id"."_"."$farmerId"),
                    'wholesaler' => $request->input("wholesaler_$id"."_"."$farmerId"),
                    'mandi' => $request->input("mandi_$id"."_"."$farmerId"),
                    'processor' => $request->input("processor_$id"."_"."$farmerId"),
                    'retailer' => $request->input("retailer_$id"."_"."$farmerId"),
                    'consumer' => $request->input("consumer_$id"."_"."$farmerId"),
                    'minimum_price' => $request->input("minimum_price_$id"."_"."$farmerId"),
                    'maximum_price' => $request->input("maximum_price_$id"."_"."$farmerId"),
                    'minimum_price_unit' => $request->input("minimum_price_unit_$id"."_"."$farmerId"),
                    'maximum_price_unit' => $request->input("maximum_price_unit_$id"."_"."$farmerId"),
                ];
                
                if ($id && !empty($crop)) {
                    DB::table('crops')->where('id', $id)->update($crop);
                }
                
                if ($id && !empty($cropCultivation)) {
                    DB::table('crop_cultivations')->where('crop_id', $id)->update($cropCultivation);
                }
                
                if ($id && !empty($outputProduction)) {
                    DB::table('production_outputs')->where('crop_id', $id)->update($outputProduction);
                }
                
                if ($id && !empty($farmerData)) {
                    $farmerUpdatedData = DB::table('farmers')->where('farmers.id', $farmerId)->update($farmerData);
                }
            }
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
       
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
    
            $query = DB::table('crops')->select(
                'crops.*',
                'users.team_leader_id',
                'users.village as user_village',
                'users.role_id',
                'users.farmer_code_id as farmer_code',
                'users.first_name as farmer_first_name',
                'users.last_name as farmer_last_name',
                'users.husband_father_name as farmer_husband_father_name',
                'states.state_name as farmer_state_name',
                'districts.district_name as farmer_district_name',
                'users.block as farmer_block',
                'users.mobile_number as farmer_mobile_number',
                'farmers.id as farmerId',
                'farmers.*',
                'crops.crop_area as crop_areas',
                'crop_cultivations.*',
                'production_outputs.*',
                'production_outputs.other as production_outputs_other',
                'crops.id as id',
                'crops.user_id as user_id'
            )
            ->leftJoin('users','users.id','=','crops.user_id')
            ->leftJoin('states', 'states.id', '=', 'users.state_id')
            ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
            ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
            ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
            ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
            ->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
                if ($current_user_role_id == 41 || $current_user_role_id == 45 || $current_user_role_id == 47 || $current_user_role_id == 48) {
                    return $query;
                }
                return $query->where(function ($query) use ($user_id) {
                    $query->where('users.team_leader_id', $user_id)
                          ->orWhere('users.id', $user_id);
                });
            });
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $query->whereDate('crops.created_at', '=', $startDate);
                } else {
                    //$query->whereBetween('crops.created_at', [$startDate, $endDate]);
                    $query->whereDate('crops.created_at', '>=', $startDate);
                    $query->whereDate('farmers.created_at', '>=', $startDate);
                    $query->whereDate('crops.created_at', '<=', $endDate);
                    $query->whereDate('farmers.created_at', '<=', $endDate);
                }
            } elseif ($startDate) {
                $query->whereDate('crops.created_at', '>=', $startDate);
                $query->whereDate('farmers.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $query->whereDate('crops.created_at', '<=', $endDate);
                $query->whereDate('farmers.created_at', '<=', $endDate);
            } else {
                $query->whereDate('crops.created_at', '=', now()->toDateString());
                $query->whereDate('farmers.created_at', '=', now()->toDateString());
            }
            
    
            $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
            return view('Anexure.anexure-one-update', [
                'data' => $data
            ]);
    
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    
    
    public function anexureTwoUpdate(Request $request)
    {
       $userAuth = Auth::user();
       $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
       $current_user_role_id = $userAuth['role_id'];
       
       try {
           if ($request->isMethod('post')) 
           {   
               $id = $request->id;
               $farmerId = $request->farmer_id;
               
            //   IrrigationInfrastructure::where('id', $id)->where('farmer_id',$farmerId)->update([
              
            IrrigationInfrastructure::where('farmer_id',$farmerId)->update([
                'canal' => json_encode($request->canel),
                'tubewell' => json_encode($request->tubewell),
                'enginer_motor_solar' => json_encode($request->enginer_motor),
                'pump_sets' => json_encode($request->pump_sets),
                'pond' => json_encode($request->pond),
                'irrigation_system' => json_encode($request->irrigation_system),
                'pump_house' => json_encode($request->pump_house),
                'other' => json_encode($request->irrigation_infrastructures_other),
            ]);
            
            FarmMechanism::where('farmer_id',$farmerId)->update([
                'tractor' => json_encode($request->tractor),
                'power_tiller' => json_encode($request->power_tiller),
                'cultivator' => json_encode($request->cultivator),
                'rotator' => json_encode($request->rotator),
                'leveller' => json_encode($request->leveller),
                'plough' => json_encode($request->plough),
                'speed_drill' => json_encode($request->speed_drill),
                'speed_planter' => json_encode($request->speed_planter),
                'speed_cum_fertilizer_drill' => json_encode($request->speed_cum_fertilizer_drill),
                'trolley' => json_encode($request->trolley),
                'reaper_cum_binder' => json_encode($request->reaper_cum_binder),
                'bhusa_machine' => json_encode($request->bhusa_machine),
                'combine_harvester' => json_encode($request->combine_harvester),
                'other' => json_encode($request->farm_mechanisms_other),
            ]);
            
            StorageStructure::where('farmer_id',$farmerId)->update([
              'deshi' => json_encode($request->deshi),
              'godown' => json_encode($request->godown),
              'clod' => json_encode($request->clod),
              'bulk_cooling' => json_encode($request->bulk_cooling),
              'fodder' => json_encode($request->fodder),
              'other' => json_encode($request->storage_structures_other),
            ]);
            
           ProcessingInfrastructure::where('farmer_id',$farmerId)->update([
            'wheat_processing' => json_encode($request->wheat_processing),
            'oil_processing' => json_encode($request->oil_processing),
            'sugarcane_processing' => json_encode($request->sugarcane_processing),
            'dal_processing' => json_encode($request->dal_processing),
            'other_processing' => json_encode($request->other_processing),
           ]);
           
           RetailOutlet::where('farmer_id',$farmerId)->update([
            'kiran_outlets' => json_encode($request->kiran_outlets),
            'grossary_outlets' => json_encode($request->grossary_outlets),
            'other_outlets' => json_encode($request->other_outlets),
           ]);
           
           OtherInfrastructure::where('farmer_id',$farmerId)->update([
               'shed_kuchha' => json_encode($request->shed_kuchha),
               'shed_pucca' => json_encode($request->shed_pucca),
               'other_infrastructure' => json_encode($request->other_infrastructure),
           ]);
           
           investment_plantation::where('farmer_id',$farmerId)->update([
               'name_plantation' => json_encode($request->name_plantation),
               'cost_pantation' => json_encode($request->cost_pantation),
               'Infrastructure' => json_encode($request->Infrastructure),
               'material' => json_encode($request->material),
               'labour_mechanization' => json_encode($request->labour_mechanization),
               'fixed_cost' => json_encode($request->fixed_cost),
           ]);
           
           return response()->json([
                    'status' => true,
                    'message' => 'Update Successfully',
                ], 200);
           
           }
           
           $startDate = $request->input('start_date');
           $endDate = $request->input('end_date');
   
           if ($startDate) {
               $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
           }
           if ($endDate) {
               $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
           }
   
           $query = DB::table('irrigation_infrastructures')->select(
             //  'users.*',
            //   'farmers.*',
               'irrigation_infrastructures.*',
               'irrigation_infrastructures.other as irrigation_infrastructures_other',
               'farm_mechanisms.*',
               'farm_mechanisms.other as farm_mechanisms_other',
               'storage_structures.*',
               'storage_structures.other as storage_structures_other',
               'processing_infrastructures.*',
               'retail_outlets.*',
               'other_infrastructures.*',
               'investment_plantations.*',
               'users.farmer_code_id as farmer_code',
               'users.first_name as farmer_first_name',
               'users.last_name as farmer_last_name'
           )
           ->leftJoin('users', 'users.id', '=', 'irrigation_infrastructures.farmer_id')
        //   ->leftJoin('farmers', 'farmers.user_id', '=', 'irrigation_infrastructures.farmer_id') 
           ->leftJoin('farm_mechanisms', 'farm_mechanisms.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
           ->leftJoin('storage_structures', 'storage_structures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
           ->leftJoin('processing_infrastructures', 'processing_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
           ->leftJoin('retail_outlets', 'retail_outlets.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
           ->leftJoin('investment_plantations', 'investment_plantations.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
           ->leftJoin('other_infrastructures', 'other_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id');
   
           // Apply date filtering if dates are provided, else use today's date
           if ($startDate && $endDate) {
               if ($startDate->eq($endDate)) {
                   // If start and end dates are the same, use whereDate for that day
                   $query->whereDate('irrigation_infrastructures.created_at', '=', $startDate);
               } else {
                   // Use a date range
                   $query->whereBetween('irrigation_infrastructures.created_at', [$startDate, $endDate]);
               }
           } elseif ($startDate) {
               $query->whereDate('irrigation_infrastructures.created_at', '>=', $startDate);
           } elseif ($endDate) {
               $query->whereDate('irrigation_infrastructures.created_at', '<=', $endDate);
           } else {
               // If no dates are provided, default to today’s date
               $query->whereDate('irrigation_infrastructures.created_at', '=', now()->toDateString());
           }
   
           // Order and paginate results
           $data = $query->orderBy('irrigation_infrastructures.created_at', 'DESC')->paginate(15);
           //dd($data);
           return view('Anexure.anexure-two-update', [
               'data' => $data
           ]);
   
       } catch (\Throwable $th) {
           return response()->json([
               'status' => false,
               'message' => $th->getMessage()
           ], 500);
       }
    }
    
    
    
    
    
     public function e_list(Request $request)
     {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
          
            // Ensure the dates are in 'Y-m-d' format
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
              
            $dataQuery2 = DB::table('backward_linkages')
                ->select(
                    'backward_linkages.*',
                    'backward_linkages.id as id',
                    'backward_linkage_twos.*',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'users.farmer_code_id'
                ) 
                ->leftJoin('users', 'users.id', '=', 'backward_linkages.farmer_id')
                ->leftJoin('backward_linkage_twos', 'backward_linkage_twos.backward_linkages_id', '=', 'backward_linkages.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('backward_linkages.farmer_id', $user_id);
                });
          
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery2->whereDate('backward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery2->orderBy('backward_linkages.farmer_id', 'DESC')->paginate(15);
            
            
            $deshboard = 2;

            return view('Anexure.anexure-e', ['data' => $data,'deshboard'=>$deshboard]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
    public function anexureEUpdate(Request $request)
    {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        $current_user_role_id = $userAuth['role_id'];
        
        try{
            
           if ($request->isMethod('post')) 
           { 
               // dd($request->all());
                $id = $request->input('id');
                $farmerId = $request->input('farmer_id');
                
            BackwardLinkage::where('id', $id)->where('farmer_id',$farmerId)->update([
                'seed' => json_encode($request->seed),
                'plantlets' => json_encode($request->plantlets),
                'fingerling_fishery' => json_encode($request->fingerling_fishery),
                'day_old_chick' => json_encode($request->day_old_chick),
                'feed' => json_encode($request->feed),
                'fertilizer' => json_encode($request->fertilizer),
                'pesticides_insec_her' => json_encode($request->pesticides_insec_her),
                'nutrients' => json_encode($request->nutrients),
                'medicine' => json_encode($request->medicine),
                'labour' => json_encode($request->labour),
                 'supply_of_diesel_fuel_electricity' => json_encode($request->supply_of_diesel_fuel_electricity),
                 'technology_transfer' => json_encode($request->technology_transfer),
                 'fm_custom_hire_services' => json_encode($request->fm_custom_hire_services),
                 'irrigation_on_custom_and_hiring' => json_encode($request->irrigation_on_custom_and_hiring),
                 'source_of_credit' => json_encode($request->source_of_credit),
                 'input_credit' => json_encode($request->input_credit),
                 'supply_credit' => json_encode($request->supply_credit),
                 'credit_from_nbsc' => json_encode($request->credit_from_nbsc),
                 'credit_from_banks' => json_encode($request->credit_from_banks),
                 'other_source' => json_encode($request->other_source),
                 'any_other_information' => json_encode($request->any_other_information),
            ]);
            
             BackwardLinkageTwo::where('backward_linkages_id', $id)->where('farmer_id',$farmerId)->update([
                'foundation_seed' => json_encode($request->foundation_seed),
                'breeder_seed' => json_encode($request->breeder_seed),
                'certified_seed' => json_encode($request->certified_seed),
                'other_seed' => json_encode($request->other_seed),
                'brand_of_seed' => json_encode($request->brand_of_seed),
                'own_seed' => json_encode($request->own_seed),
                'seed_purchase_from_market' => json_encode($request->seed_purchase_from_market),
                'any_other_source' => json_encode($request->any_other_source),
                'source_distance_km' => json_encode($request->source_distance_km),
                'any_other' => json_encode($request->any_other),
             ]);    
                
             return response()->json([
                    'status' => true,
                    'message' => 'Update Successfully',
             ], 200);
           
               
           }
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
          
            // Ensure the dates are in 'Y-m-d' format
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
              
            $dataQuery2 = DB::table('backward_linkages')
                ->select(
                    'backward_linkages.*',
                    'backward_linkages.id as id',
                    'backward_linkage_twos.foundation_seed',
                     'backward_linkage_twos.breeder_seed',
                     'backward_linkage_twos.certified_seed',
                     'backward_linkage_twos.other_seed',
                     'backward_linkage_twos.brand_of_seed',
                     'backward_linkage_twos.own_seed',
                     'backward_linkage_twos.seed_purchase_from_market',
                     'backward_linkage_twos.any_other_source',
                     'backward_linkage_twos.source_distance_km',
                     'backward_linkage_twos.any_other',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'users.farmer_code_id'
                ) ->leftJoin('users', 'users.id', '=', 'backward_linkages.farmer_id')
                  ->leftJoin('backward_linkage_twos', 'backward_linkage_twos.backward_linkages_id', '=', 'backward_linkages.id')
                  ->when($user_id, function ($query, $user_id) {
                    return $query->where('backward_linkages.farmer_id', $user_id);
                });
          
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery2->whereDate('backward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery2->orderBy('backward_linkages.farmer_id', 'DESC')->paginate(15);
            //dd($data);
            
            $deshboard = 2;

            return view('Anexure.anexure-e-update', ['data' => $data,'deshboard'=>$deshboard]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
  
   
    public function f_list(Request $request)
    {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            // Ensure the dates are in 'Y-m-d' format
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('forward_linkages')
                ->select(
                    'forward_linkages.*',
                    'users.team_leader_id',
                    'users.farmer_code_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'forward_linkages.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('forward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);

            $deshboard = 2;

           
            return view('Anexure.anexure-f', ['data' => $data,'deshboard'=>$deshboard]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
    public function anexureFUpdate(Request $request)
    {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            
          if ($request->isMethod('post')) 
           { 
                //dd($request->all());
                $id = $request->input('id');
                $farmerId = $request->input('farmer_id');
                
                ForwardLinkage::where('id', $id)->where('farmer_id',$farmerId)->update([
                    'marketing_channel' => json_encode($request->marketing_channel),
                    'marketing_channel_distance' => json_encode($request->marketing_channel_distance),
                    'transportation_method' => json_encode($request->transportation_method),
                    'transport_by' => json_encode($request->transport_by),
                    'transport_expenses' => json_encode($request->transport_expenses),
                    'primary_processing' => json_encode($request->primary_processing),
                    'buyer_institution_present' => json_encode($request->buyer_institution_present),
                    'formal_informal_contract' => json_encode($request->formal_informal_contract),
                    'niche_market' => json_encode($request->niche_market),
                    'secondary_processing' => json_encode($request->secondary_processing),
                    'processing_in_vicinity' => json_encode($request->processing_in_vicinity),
                    'storage_facility' => json_encode($request->storage_facility),
                    'storage' => json_encode($request->storage),
                    'facility_capacity' => json_encode($request->facility_capacity),
                    'storage_charges' => json_encode($request->storage_charges),
                    'storage_duretion' => json_encode($request->storage_duretion),
                    'time_of_sale' => json_encode($request->time_of_sale),
                    'road_connectivity' => json_encode($request->road_connectivity),
                    'payment_of_sale' => json_encode($request->payment_of_sale),
                    'total_sale_value' => json_encode($request->total_sale_value),
                    'weighing_method' => json_encode($request->weighing_method),
                    'extent_of_under_weighing' => json_encode($request->extent_of_under_weighing),
                    'source_of_market_info' => json_encode($request->source_of_market_info),
                    'total_marketable_surplus' => json_encode($request->total_marketable_surplus),
                    'selling_on_msp' => json_encode($request->selling_on_msp),
                    'extent_of_msp_price' => json_encode($request->extent_of_msp_price),
                ]);
                 return response()->json([
                        'status' => true,
                        'message' => 'Update Successfully',
                 ], 200);
           }
            
            
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            // Ensure the dates are in 'Y-m-d' format
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('forward_linkages')
                ->select(
                    'forward_linkages.*',
                    'users.team_leader_id',
                    'users.farmer_code_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name',
                    'forward_linkages.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('forward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);

            $deshboard = 2;

           
            return view('Anexure.anexure-f-update', ['data' => $data,'deshboard'=>$deshboard]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }

    
    // public function anexureOneUpdate(Request $request)
    // {
    //     try {
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
            
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
            
    //         $query = DB::table('crops')
    //             ->select(
    //                 'crops.*',
    //                 'farmers.*',
    //                 'crop_cultivations.*',
    //                 'production_outputs.*',
    //                 'production_outputs.other as production_outputs_other',
    //                 'irrigation_infrastructures.*',
    //                 'irrigation_infrastructures.other as irrigation_infrastructures_other',
    //                 'farm_mechanisms.*',
    //                 'farm_mechanisms.other as farm_mechanisms_other',
    //                 'storage_structures.*',
    //                 'storage_structures.other as storage_structures_other',
    //                 'processing_infrastructures.*',
    //                 'retail_outlets.*',
    //                 'other_infrastructures.*',
    //                 'crops.id as id'
    //             )
    //             ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
    //             ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
    //             ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
    //             ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
    //             ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
    //             ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
    //             ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id');
                
    //         if ($startDate && $endDate) {
    //             if ($startDate->eq($endDate)) {
    //                 $query->whereDate('crops.created_at', '=', $startDate);
    //             } else {
    //                 $query->whereBetween('crops.created_at', [$startDate, $endDate]);
    //             }
    //         } elseif ($startDate) {
    //             $query->whereDate('crops.created_at', '>=', $startDate);
    //         } elseif ($endDate) {
    //             $query->whereDate('crops.created_at', '<=', $endDate);
    //         } else {
    //             $query->whereDate('crops.created_at', '=', now()->toDateString());
    //         }
    
    //         $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
    //         if ($request->isMethod('post'))
    //         {
    //             $id = $request->input('data_id');
    //             $crop = [
    //                 'crop_name' => $request->crop_name,
    //                 'irrigated_area' => $request->irrigated_area,
    //                 'crop_area' => $request->crop_area
    //             ];
    //             if(isset($crop) && $crop != null){
    //               $updateData = DB::table('crops')->where('id',$id)->update($crop);
    //             }
    //         }
            
    //         // if ($request->isMethod('post')) 
    //         // {
    //         //     $updateTable = json_decode($request->input('update_table', '[]'), true);
    //         //     $dataValue = [
    //         //         'farmer_id' => $request->input('farmer_id', []),
    //         //         'crop_name' => $request->input('crop_name', []),
    //         //     ];
    //         //     if (is_array($updateTable)) {
    //         //         foreach ($updateTable as $index => $table) {
    //         //             $conditions = [];
    //         //             $updateData = [];
    //         //             foreach ($dataValue as $key => $values) {
    //         //                 if (isset($values[$index])) {
    //         //                     if (Schema::hasColumn($table, $key)) {
    //         //                         $updateData[$key] = $values[$index];
    //         //                     } else {
    //         //                         continue;
    //         //                     }
    //         //                 }
    //         //             }
    
    //         //             foreach ($dataValue as $key => $values) {
    //         //                 if (isset($values[$index])) {
    //         //                     if (Schema::hasColumn($table, $key)) {
    //         //                         $conditions[$key] = $values[$index];
    //         //                     }
    //         //                 }
    //         //             }
    
    //         //             if (!empty($conditions) && !empty($updateData) && Schema::hasTable($table)) {
    //         //                 DB::table($table)->where($conditions)->update($updateData);
    //         //             } else {
    //         //                 return response()->json([
    //         //                     'status' => false,
    //         //                     'message' => "Table $table does not exist or no valid conditions/update data provided"
    //         //                 ], 400);
    //         //             }
    //         //         }
    //         //     } else {
    //         //         return response()->json([
    //         //             'status' => false,
    //         //             'message' => 'Invalid update_table format'
    //         //         ], 400);
    //         //     }
    //         // }
            
    //         return view('Anexure.anexure-one-update', [
    //             'data' => $data,
    //             'updateTable' => $updateTable ?? []
    //         ]);
        
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    
    // public function anexureOneUpdate(Request $request, $value = null)
    // {
    //     try {
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
            
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
            
    //         $query = DB::table('crops')
    //             ->select(
    //                 'crops.*',
    //                 'farmers.*',
    //                 'crop_cultivations.*',
    //                 'production_outputs.*',
    //                 'production_outputs.other as production_outputs_other',
    //                 'irrigation_infrastructures.*',
    //                 'irrigation_infrastructures.other as irrigation_infrastructures_other',
    //                 'farm_mechanisms.*',
    //                 'farm_mechanisms.other as farm_mechanisms_other',
    //                 'storage_structures.*',
    //                 'storage_structures.other as storage_structures_other',
    //                 'processing_infrastructures.*',
    //                 'retail_outlets.*',
    //                 'other_infrastructures.*'
    //             )
    //             ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
    //             ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
    //             ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
    //             ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
    //             ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
    //             ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
    //             ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id');
                
    //         if ($startDate && $endDate) {
    //             if ($startDate->eq($endDate)) {
    //                 $query->whereDate('crops.created_at', '=', $startDate);
    //             } else {
    //                 $query->whereBetween('crops.created_at', [$startDate, $endDate]);
    //             }
    //         } elseif ($startDate) {
    //             $query->whereDate('crops.created_at', '>=', $startDate);
    //         } elseif ($endDate) {
    //             $query->whereDate('crops.created_at', '<=', $endDate);
    //         } else {
    //             $query->whereDate('crops.created_at', '=', now()->toDateString());
    //         }
    
    //         // Fetch data for the view
    //         $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
    //         $updateTable = $request->input('update_table');
    //         if ($request->isMethod('post')) 
    //         {
    //             $data = $request->toArray();
    //             $updateTables = json_decode($request->input('update_table'), true);
    //             $ids = $request->input('ids');
    //             $fieldValues = $request->except(['_token', 'update_table', 'ids']);
        
    //             if ($updateTables && $ids) {
    //                 foreach ($updateTables as $table) {
    //                     $fieldNames = $this->getFieldNames($table);
        
    //                     if ($fieldNames) {
    //                         foreach ($ids as $index => $id) {
    //                             $updateData = [];
    //                             foreach ($fieldNames as $field) {
    //                                 $updateData[$field] = $request->input($field)[$index] ?? null;
    //                             }
                                
    //                             $dataUpdate = DB::table($table)->where('id', $id)->update($updateData);
    //                         }
    //                     }
    //                 }
    //             }
    //         }
    
    //         return view('Anexure.anexure-one-update', [
    //             'data' => $data,
    //             'updateTable' => $updateTable
    //         ]);
        
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    

    // private function getFieldNames($table)
    // {
    //     $fields = [
    //         'crops' => [
    //             'farmer_id', 'crop_name', 'crop_area_unit', 'irrigated_area', 'season', 'crop_area'
    //         ],
    //         'crop_cultivations' => [
    //             'family_labour_hrs', 'family_labour_rs', 'attached_labour_hrs', 'attached_labour_rs', 'casual_labour_rs', 'casual_labour_hrs', 'hired_animal_labour_rs', 'hired_animal_labour_hrs', 'family_labour_unit_price', 'attached_labour_unit_price',
    //             'casual_labour_unit_price', 'hired_animal_hrs', 'hired_animal_unit_price', 'hired_animal_rs', 'family_labour_remarks', 'family_labour_unit', 'attached_labour_remarks', 'attached_labour_unit', 'casual_labour_remarks', 'casual_labour_unit', 'hired_animal_remarks',
    //             'hired_animal_unit', 'owned_animal_hrs', 'owned_animal_rs', 'hired_machhine_hrs', 'hired_machhine_rs', 'own_machine_rs', 'own_machine_hrs', 'hired_irrigation_machine_hrs', 'hired_irrigation_machine_rs', 'owned_animal_unit_price', 'owned_animal_unit',
    //             'hired_machhine_unit_price', 'hired_machhine_remarks', 'hired_machhine_unit', 'own_machine_unit_price', 'own_machine_remarks', 'own_machine_unit', 'hired_irrigation_machine_unit_price', 'hired_irrigation_machine_remarks', 'hired_irrigation_machine_unit', 'owned_irrigation_machine_unit_price',
    //             'owned_irrigation_machine_remarks', 'owned_irrigation_machine_unit', 'owned_irrigation_machine_hrs', 'owned_irrigation_machine_rs', 'other_irrigation_charges_hrs', 'seed_value_rs', 'fertiliser_n_rs', 'fertiliser_p_rs', 'fertiliser_k_rs', 'seed_qty_unit', 'seed_qty', 'seed_unit_price', 'seed_remarks',
    //             'seed_variety', 'fertiliser_n_qty_unit', 'fertiliser_n_qty', 'fertiliser_n_unit_price', 'fertiliser_n_remarks', 'fertiliser_p_qty_unit', 'fertiliser_p_qty', 'fertiliser_p_unit_price', 'fertiliser_p_remarks', 'fertiliser_k_qty_unit', 'fertiliser_k_qty', 'fertiliser_k_unit_price', 'fertiliser_k_remarks',
    //             'other_fertiliser_kg', 'other_fertiliser_rs', 'dap_kg', 'dap_rs', 'npk_kg', 'npk_rs', 'manure_qtl', 'manure_rs', 'other_fertiliser_qty_unit', 'other_fertiliser_qty_unit_remarks', 'other_fertiliser_qty', 'other_fertiliser_unit_price', 'other_fertiliser_remarks', 'dap_qty_unit', 'dap_unit_remarks', 'dap_qty',
    //             'dap_unit_price', 'dap_remarks', 'npk_qty_unit', 'npk_qty_unit_remarks', 'npk_qty', 'npk_unit_price', 'npk_remarks', 'manure_qty_unit', 'manure_qty_unit_remarks', 'manure_qty', 'manure_unit_price', 'manure_remarks', 'crop_insurance_rs', 'insecticide_unit', 'insecticide_qty',
    //             'insecticide_unit_price', 'insecticide_rs', 'land_revenue_rs', 'rent_paid_leased_land', 'interest_kcc', 'canal_other_charges', 'seed_type', 'insecticide_remarks'
    //         ],
    //         'production_outputs' => [
    //             'total_production', 'sold_main_product', 'selling_price_main_product', 'by_product', 'selling_price_by_product', 'village_trader','wholesaler','mandi','processor','retailer','consumer','total_production_unit','sold_main_product_unit','total_main_product_sold','company','commission_agent','other'
    //         ],
    //         'farm_mechanisms' => [
    //             'tractor', 'power_tiller', 'cultivator', 'rotator', 'harrow', 'leveller','plough','speed_drill','speed_planter','speed_cum_fertilizer_drill','trolley','reaper_cum_binder','bhusa_machine','thresher','combine_harvester','other'
    //         ],
    //         'irrigation_infrastructures' => [
    //             'canal', 'tubewell', 'enginer_motor_solar', 'pump_sets', 'pond', 'irrigation_system','pump_house','other'
    //         ],
    //         'storage_structures' => [
    //             'deshi', 'godown', 'clod', 'bulk_cooling', 'fodder', 'other'
    //         ],
    //         'processing_infrastructures' => [
    //             'wheat_processing', 'oil_processing', 'sugarcane_processing', 'dal_processing', 'other_processing'
    //         ],
    //         'retail_outlets' => [
    //             'kiran_outlets', 'grossary_outlets', 'other_outlets'
    //         ],
    //         'other_infrastructures' => [
    //             'shed_kuchha', 'shed_pucca', 'other_infrastructure'
    //         ],
    //     ];
    
    //     return $fields[$table] ?? [];
        
    //     // $tableNames = array_keys($fields);
    //     // return [
    //     //     'fields' => $tableNames ?? []
    //     // ];
    // }
    
    // public function anexureOneUpdate(Request $request, $value = null)
    // {
    //     try {
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
            
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
            
    //         $query = DB::table('crops')
    //             ->select('crops.*',
    //                 'farmers.*',
    //                 'crops.crop_area as crop_areas',
    //                 'crop_cultivations.*',
    //                 'production_outputs.*',
    //                 'irrigation_infrastructures.*',
    //                 'farm_mechanisms.*',
    //                 'storage_structures.*',
    //                 'processing_infrastructures.*',
    //                 'retail_outlets.*',
    //                 'other_infrastructures.*'
    //             )
    //             ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
    //             ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
    //             ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
    //             ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
    //             ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
    //             ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
    //             ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
    //             ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id');
                
    //         if ($startDate && $endDate) {
    //             if ($startDate->eq($endDate)) {
    //                 $query->whereDate('crops.created_at', '=', $startDate);
    //             } else {
    //                 $query->whereBetween('crops.created_at', [$startDate, $endDate]);
    //             }
    //         } elseif ($startDate) {
    //             $query->whereDate('crops.created_at', '>=', $startDate);
    //         } elseif ($endDate) {
    //             $query->whereDate('crops.created_at', '<=', $endDate);
    //         } else {
    //             $query->whereDate('crops.created_at', '=', now()->toDateString());
    //         }
    
    //         // Fetch data for the view
    //         $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
    //         $updateTable = $request->input('update_table');

    //         if ($updateTable === 'crops') {
    //             $fieldNames = ['farmer_id', 'crop_name', 'crop_area_unit', 'irrigated_area', 'season','crop_area'];
    //             $ids = $request->input('ids');

    //             foreach ($ids as $index => $id) {
    //                 $updateData = [];
    //                 foreach ($fieldNames as $field) {
    //                     $updateData[$field] = $request->input($field)[$index] ?? null;
    //                 }
    //                 DB::table('crops')->where('id', $id)->update($updateData);
    //             }
    //         } elseif ($updateTable === 'crop_cultivations') {
    //             $fieldNames = ['family_labour_hrs', 'family_labour_rs','attached_labour_hrs','attached_labour_rs','casual_labour_rs','casual_labour_hrs','hired_animal_labour_rs','hired_animal_labour_hrs','family_labour_unit_price','attached_labour_unit_price',
    //             'casual_labour_unit_price','hired_animal_hrs','hired_animal_unit_price','hired_animal_rs','family_labour_remarks','family_labour_unit','attached_labour_remarks','attached_labour_unit','casual_labour_remarks','casual_labour_unit','hired_animal_remarks',
    //             'hired_animal_unit','owned_animal_hrs','owned_animal_rs','hired_machhine_hrs','hired_machhine_rs','own_machine_rs','own_machine_hrs','hired_irrigation_machine_hrs','hired_irrigation_machine_rs','	owned_animal_unit_price','owned_animal_remarks','owned_animal_unit',
    //             'hired_machhine_unit_price','hired_machhine_remarks','hired_machhine_unit','own_machine_unit_price','own_machine_remarks','	own_machine_unit','hired_irrigation_machine_unit_price','hired_irrigation_machine_remarks','hired_irrigation_machine_unit','owned_irrigation_machine_unit_price',
    //             'owned_irrigation_machine_remarks','owned_irrigation_machine_unit','owned_irrigation_machine_hrs','owned_irrigation_machine_rs','other_irrigation_charges_hrs','seed_value_rs','fertiliser_n_rs','fertiliser_p_rs','fertiliser_k_rs','seed_qty_unit','seed_qty','seed_unit_price','seed_remarks',
    //             'seed_variety','fertiliser_n_qty_unit','fertiliser_n_qty','fertiliser_n_unit_price','fertiliser_n_remarks','fertiliser_p_qty_unit','fertiliser_p_qty','fertiliser_p_unit_price','fertiliser_p_remarks','fertiliser_k_qty_unit','fertiliser_k_qty','	fertiliser_k_unit_price','fertiliser_k_remarks',
    //             'other_fertiliser_kg','other_fertiliser_rs','dap_kg','dap_rs','npk_kg','npk_rs','manure_qtl','manure_rs','other_fertiliser_qty_unit','other_fertiliser_qty_unit_remarks','other_fertiliser_qty','other_fertiliser_unit_price','	other_fertiliser_remarks','dap_qty_unit','dap_unit_remarks','dap_qty',
    //             'dap_unit_price','dap_remarks','npk_qty_unit','npk_qty_unit_remarks','npk_qty','npk_unit_price','npk_remarks','depericiation_farm_assets','	manure_qty_unit','manure_qty_unit_remarks','manure_qty','manure_unit_price','manure_remarks','crop_insurance_rs','insecticide_unit','insticide_name','	insecticide_qty',
    //             'insecticide_unit_price','insecticide_rs','miscelaneous_cost_rs','land_revenue_rs','rent_paid_leased_land','interest_kcc','canal_other_charges','seed_type','insecticide_remarks'];
    //             $ids = $request->input('ids');

    //             foreach ($ids as $index => $id) {
    //                 $updateData = [];
    //                 foreach ($fieldNames as $field) {
    //                     $updateData[$field] = $request->input($field)[$index] ?? null;
    //                 }
    //                 DB::table('crop_cultivations')->where('id', $id)->update($updateData);
    //             }
    //         }
    
    //         return view('Anexure.anexure-one-update', ['data' => $data]);
        
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }

    
    // public function anexureOneUpdate(Request $request, $value)
    // {
    //     try {
            
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
            
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
            
    //         $query = DB::table('crops')
    //             ->select('crops.*','farmers.*','crops.crop_area as crop_areas','crop_cultivations.*','production_outputs.*','irrigation_infrastructures.*','farm_mechanisms.*','storage_structures.*','processing_infrastructures.*','retail_outlets.*','other_infrastructures.*')
    //             ->leftJoin('farmers','farmers.id','=','crops.farmer_id')
    //             ->leftJoin('crop_cultivations','crop_cultivations.crop_id','=','crops.id')
    //             ->leftJoin('production_outputs','production_outputs.crop_id','=','crops.id')
    //             ->leftJoin('farm_mechanisms','farm_mechanisms.crop_id','=','crops.id')
    //             ->leftJoin('irrigation_infrastructures','irrigation_infrastructures.crop_id','=','crops.id')
    //             ->leftJoin('storage_structures','storage_structures.crop_id','=','crops.id')
    //             ->leftJoin('processing_infrastructures','processing_infrastructures.crop_id','=','crops.id')
    //             ->leftJoin('retail_outlets','retail_outlets.crop_id','=','crops.id')
    //             ->leftJoin('other_infrastructures','other_infrastructures.crop_id','=','crops.id');
                
    //         if ($startDate && $endDate) {
    //             if ($startDate->eq($endDate)) {
    //                 $query->whereDate('crops.created_at', '=', $startDate);
    //             } else {
    //                 $query->whereBetween('crops.created_at', [$startDate, $endDate]);
    //             }
    //         } elseif ($startDate) {
    //             $query->whereDate('crops.created_at', '>=', $startDate);
    //         } elseif ($endDate) {
    //             $query->whereDate('crops.created_at', '<=', $endDate);
    //         } else {
    //             $query->whereDate('crops.created_at', '=', now()->toDateString());
    //         }
    
    //         $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
            
    //         if($request->toArray())
    //         {
    //             // $request->validate([
    //             //     'field1' => 'required',
    //             //     'field2' => 'required',
    //             // ]);
        
    //             // $crop = Crop::findOrFail($id);
        
    //             // $crop->field1 = $request->input('field1');
    //             // $crop->field2 = $request->input('field2');
    //             // $crop->save();
    //         }
    
    //         return view('Anexure.anexure-one-update',['data'=>$data]);
    
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    
    public function updateAnnexureTwoStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'last_year_id'   => $id,
            'status'    => $status
        ], [
            'last_year_id'   =>  'required|exists:last_year_productions,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.two',['date' => $date])->with('error', $validate->errors()->first());
        }
        
        try {
            DB::beginTransaction();
            // dd($status);
            LastYearProduction::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.two',['date' => $date])->with('success','Annexure two Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    
    //  public function two_list(Request $request)
    //  {
        
    //     $userAuth = Auth::user();
    //     $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
    //     $current_user_role_id = $userAuth['role_id'];
       
    //     try {
            
    //         $startDate = $request->input('start_date');
    //         $endDate = $request->input('end_date');
          
           
    //         if ($startDate) {
    //             $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
    //         }
    //         if ($endDate) {
    //             $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
    //         }
            
    //         // $query = DB::table('crops')->select(
    //         //     'crops.*',
    //         //     'users.team_leader_id',
    //         //     'users.village as user_village',
    //         //     'users.role_id',
    //         //     'users.farmer_code_id as farmer_code',
    //         //     'users.first_name as farmer_first_name',
    //         //     'users.last_name as farmer_last_name',
    //         //     'users.husband_father_name as farmer_husband_father_name',
    //         //     'states.state_name as farmer_state_name',
    //         //     'districts.district_name as farmer_district_name',
    //         //     'users.block as farmer_block',
    //         //     'users.mobile_number as farmer_mobile_number',
    //         //     'farmers.id as farmerId',
    //         //     'farmers.*',
    //         //     'crops.crop_area as crop_areas',
    //         //     'crop_cultivations.*',
    //         //     'production_outputs.*',
    //         //     'production_outputs.other as production_outputs_other',
    //         //     'irrigation_infrastructures.*',
    //         //     'irrigation_infrastructures.other as irrigation_infrastructures_other',
    //         //     'farm_mechanisms.*',
    //         //     'farm_mechanisms.other as farm_mechanisms_other',
    //         //     'storage_structures.*',
    //         //     'storage_structures.other as storage_structures_other',
    //         //     'processing_infrastructures.*',
    //         //     'retail_outlets.*',
    //         //     'other_infrastructures.*',
    //         //     'investment_plantations.*',
    //         //     'crops.id as id',
    //         //     'crops.user_id as user_id'
    //         // )
    //         // ->leftJoin('users','users.id','=','crops.user_id')
    //         // //->leftJoin('users as farmers','farmers.id','=','crops.farmer_id')
            
    //         // ->leftJoin('states', 'states.id', '=', 'users.state_id')
    //         // ->leftJoin('districts', 'districts.id', '=', 'users.district_id')
    //         // // ->leftJoin('farmers', 'farmers.id', '=', 'crops.farmer_id')
            
    //         // ->leftJoin('farmers', 'farmers.user_id', '=', 'crops.farmer_id')
            
    //         //  ->leftJoin('crop_cultivations', 'crop_cultivations.crop_id', '=', 'crops.id')
            
    //         // ->leftJoin('production_outputs', 'production_outputs.crop_id', '=', 'crops.id')
    //         // ->leftJoin('farm_mechanisms', 'farm_mechanisms.crop_id', '=', 'crops.id')
            
    //         // ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.crop_id', '=', 'crops.id')
            
    //         // ->leftJoin('storage_structures', 'storage_structures.crop_id', '=', 'crops.id')
    //         // ->leftJoin('processing_infrastructures', 'processing_infrastructures.crop_id', '=', 'crops.id')
    //         // ->leftJoin('retail_outlets', 'retail_outlets.crop_id', '=', 'crops.id')
    //         // ->leftJoin('investment_plantations', 'investment_plantations.crop_id', '=', 'crops.id')
    //         // ->leftJoin('other_infrastructures', 'other_infrastructures.crop_id', '=', 'crops.id')
            
    //         // ->when($user_id, function ($query) use ($user_id, $current_user_role_id) {
    //         //     if ($current_user_role_id == 41 || $current_user_role_id == 45 || $current_user_role_id == 47 || $current_user_role_id == 48) {
    //         //         return $query;
    //         //     }
    //         //     return $query->where(function ($query) use ($user_id) {
    //         //         $query->where('users.team_leader_id', $user_id)
    //         //               ->orWhere('users.id', $user_id);
    //         //     });
    //         // });
            
    //         $query = DB::table('irrigation_infrastructures')->select(
    //             'users.*',
    //             'farmers.*',
    //             'irrigation_infrastructures.*',
    //             'irrigation_infrastructures.other as irrigation_infrastructures_other',
    //             'farm_mechanisms.*',
    //             'farm_mechanisms.other as farm_mechanisms_other',
    //             'storage_structures.*',
    //             'storage_structures.other as storage_structures_other',
    //             'processing_infrastructures.*',
    //             'retail_outlets.*',
    //             'other_infrastructures.*',
    //             'investment_plantations.*'
    //         )
    //         ->leftJoin('users','users.id','=','irrigation_infrastructures.farmer_id')
            
    //         ->leftJoin('farmers','farmers.user_id','=','irrigation_infrastructures.farmer_id') 
            
    //         ->leftJoin('farm_mechanisms', 'farm_mechanisms.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         // ->leftJoin('irrigation_infrastructures', 'irrigation_infrastructures.farmer_id', '=', 'farmers.user_id')
    //         ->leftJoin('storage_structures', 'storage_structures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         ->leftJoin('processing_infrastructures', 'processing_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         ->leftJoin('retail_outlets', 'retail_outlets.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         ->leftJoin('investment_plantations', 'investment_plantations.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         ->leftJoin('other_infrastructures', 'other_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
    //         ->orderBy('irrigation_infrastructures.farmer_id', 'DESC')->paginate(15);
            
    //         // $data = $query->orderBy('irrigation_infrastructures.farmer_id', 'DESC')->paginate(15);
            
    //          $data = $query;
    //          //dd($data);
            
    //         // if ($startDate && $endDate) {
    //         //     if ($startDate->eq($endDate)) {
    //         //         $query->whereDate('irrigation_infrastructures.created_at', '=', $startDate);
    //         //     } else {
    //         //       $query->whereBetween('irrigation_infrastructures.created_at', [$startDate, $endDate]);
                
                 
    //         //     }
                
                
                
    //         // } elseif ($startDate) {
    //         //     $query->whereDate('irrigation_infrastructures.created_at', '>=', $startDate);
    //         // } elseif ($endDate) {
    //         //     $query->whereDate('irrigation_infrastructures.created_at', '<=', $endDate);
    //         // } else {
    //         //     $query->whereDate('irrigation_infrastructures.created_at', '=', now()->toDateString());
    //         // }
            
    //         // $data = $query->orderBy('farmers.id', 'DESC')->paginate(15);
          
            
    //         $deshboard = 2;
    //         return view('Anexure.anexure-two', ['data' => $data,'deshboard'=>$deshboard]);
            
    //     } catch (\Throwable $th) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => $th->getMessage()
    //         ], 500);
    //     }
    // }
    
    
    public function two_list(Request $request)
    {
    $userAuth = Auth::user();
    $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
    $current_user_role_id = $userAuth['role_id'];

    try {
        // Parse start and end dates from request, if available
        $startDate = $request->input('start_date') 
            ? \Carbon\Carbon::createFromFormat('Y-m-d', $request->input('start_date'))->startOfDay()
            : null;

        $endDate = $request->input('end_date') 
            ? \Carbon\Carbon::createFromFormat('Y-m-d', $request->input('end_date'))->endOfDay()
            : null;

        // Build the query with all necessary joins
        $query = DB::table('irrigation_infrastructures')->select(
            'users.*',
            'irrigation_infrastructures.*',
            'irrigation_infrastructures.other as irrigation_infrastructures_other',
            'farm_mechanisms.*',
            'farm_mechanisms.other as farm_mechanisms_other',
            'storage_structures.*',
            'storage_structures.other as storage_structures_other',
            'processing_infrastructures.*',
            'retail_outlets.*',
            'other_infrastructures.*',
            'investment_plantations.*'
        )
        ->leftJoin('users', 'users.id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('farm_mechanisms', 'farm_mechanisms.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('storage_structures', 'storage_structures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('processing_infrastructures', 'processing_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('retail_outlets', 'retail_outlets.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('investment_plantations', 'investment_plantations.farmer_id', '=', 'irrigation_infrastructures.farmer_id')
        ->leftJoin('other_infrastructures', 'other_infrastructures.farmer_id', '=', 'irrigation_infrastructures.farmer_id');

        // Apply date filtering if dates are provided, else use today's date
        if ($startDate && $endDate) {
            if ($startDate->eq($endDate)) {
                // If start and end dates are the same, use whereDate for that day
                $query->whereDate('irrigation_infrastructures.created_at', '=', $startDate);
            } else {
                // Use a date range
                $query->whereBetween('irrigation_infrastructures.created_at', [$startDate, $endDate]);
            }
        } elseif ($startDate) {
            $query->whereDate('irrigation_infrastructures.created_at', '>=', $startDate);
        } elseif ($endDate) {
            $query->whereDate('irrigation_infrastructures.created_at', '<=', $endDate);
        } else {
            // If no dates are provided, default to today’s date
            $query->whereDate('irrigation_infrastructures.created_at', '=', now()->toDateString());
        }

        // $data = $query->orderBy('irrigation_infrastructures.farmer_id', 'DESC')->paginate(15);

        // Order and paginate results
        $data = $query->orderBy('irrigation_infrastructures.created_at', 'DESC')->paginate(15);
       
        $deshboard = 2;
        return view('Anexure.anexure-two', ['data' => $data, 'deshboard' => $deshboard]);

    } catch (\Throwable $th) {
        return response()->json([
            'status' => false,
            'message' => $th->getMessage()
        ], 500);
    }
}

    
    
    
    public function three_list(Request $request)
    {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $currentYear = date('Y');
            $lastThreeYears = [$currentYear - 3, $currentYear - 2, $currentYear - 1, $currentYear];
           
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
           
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            $dataQuery = DB::table('last_year_productions')
                ->select(
                    'last_year_productions.*', 
                    'users.farmer_code_id',
                      'users.first_name as farmer_first_name',
                      'users.last_name as farmer_last_name',
                    'users.team_leader_id'
                )
                ->distinct()
                ->leftJoin('users', 'users.id', '=', 'last_year_productions.farmer_id')
                ->leftJoin('agriculture_activities', 'agriculture_activities.farmer_id', '=', 'last_year_productions.farmer_id')
             
                ->where(function ($query) use ($lastThreeYears) {
                    $query->whereIn('last_year_productions.first_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
                })
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
                
            
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('last_year_productions.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
            } else {
                 $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            }
            $data = $dataQuery->orderBy('last_year_productions.id', 'DESC')->paginate(15);
            $deshboard = 2;
            return view('Anexure.anexure-three', ['data' => $data, 'lastThreeYears' => $lastThreeYears , 'deshboard'=>$deshboard]);

      }
      catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
  }
   
   
   public function anexureThreeUpdate(Request $request)
   {
       
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            if ($request->isMethod('post')) 
            {   
                //dd($request->all());
                $id = $request->input('id');
                $farmerid = $request->input('farmarid');
                
                LastYearProduction::where('id',$id)->where('farmer_id',$farmerid)->update([
                        "variety" => $request->input("variety"),
                        "first_year_area_unit" => $request->input("first_year_area_unit"),
                        "first_year_area" => $request->input("first_year_area"),
                        "first_year_production_unit" => $request->input("first_year_production_unit"),
                        "first_year_production" => $request->input("first_year_production"),
                        "second_year_area_unit" => $request->input("second_year_area_unit"),
                        "second_year_area" => $request->input("second_year_area"),
                        "second_year_production_unit" => $request->input("second_year_production_unit"),
                        "second_year_production" =>$request->input("second_year_production"),
                        "third_year_area_unit" => $request->input("third_year_area_unit"),
                        
                        "third_year_area" => $request->input("third_year_area"),
                        
                        "third_year_production_unit" => $request->input("third_year_production_unit"),
                        "third_year_production" => $request->input("third_year_production"),
                        "marketed_surplus" => $request->input("marketed_surplus"),
                        "net_area_under_nest_season" => $request->input("net_area_under_nest_season"),
                        "average_price_selling" => $request->input("average_price_selling"),
                        "min_rate" => $request->input("min_rate"),
                        "max_rate" => $request->input("max_rate"),
                        "remark" => $request->input("remark")
                ]);
                 $request->session()->flash('success', "Update Sucessfull");
                 return back();
            }
            
            
            $currentYear = date('Y');
            $lastThreeYears = [$currentYear - 3, $currentYear - 2, $currentYear - 1, $currentYear];
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('last_year_productions')
                ->select(
                    'last_year_productions.*', 
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name'
                )
                
                ->leftJoin('users', 'users.id', '=', 'last_year_productions.farmer_id')
                ->where(function ($query) use ($lastThreeYears) {
                    $query->whereIn('last_year_productions.first_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.second_year', $lastThreeYears)
                          ->orWhereIn('last_year_productions.third_year', $lastThreeYears);
                })
                ->when($user_id, function ($query, $user_id) {
                    // return $query->where('users.team_leader_id', $user_id);
                    return $query->where('users.id', $user_id);
                })
                ->orderBy('last_year_productions.farmer_id');
            
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('last_year_productions.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('last_year_productions.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('last_year_productions.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('last_year_productions.created_at', '=', now()->toDateString());
            }
            $deshboard = 2 ;
            $data = $dataQuery->orderBy('last_year_productions.id', 'DESC')->paginate(15);
           
            return view('Anexure.anexure-three-update', ['data' => $data, 'lastThreeYears' => $lastThreeYears,'deshboard'=>$deshboard]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   public function updateAnnexureThreeStatus(Request $request, $id, $status)
   {
        $validate = Validator::make([
            'agri_act_id'   => $id,
            'status'    => $status
        ], [
            'agri_act_id'   =>  'required|exists:agriculture_activities,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.three',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            AgricultureActivity::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.three',['date' => $date])->with('success','Annexure three Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
//   public function three_list(Request $request)
//   {
//         $userAuth = Auth::user();
//         $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
//         try{
//             $startDate = $request->input('start_date');
//             $endDate = $request->input('end_date');
             
//             if ($startDate) {
//                 $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
//             }
//             if ($endDate) {
//                 $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
//             }
            
//             $dataQuery = DB::table('agriculture_activities')
//                 ->select(
//                     'agriculture_activities.*', 
//                     'users.farmer_code_id'
//                     // 'farmers.*',
//                     // 'users.team_leader_id',
//                     // 'agriculture_activities.id as id'
//                 )
//                 // ->leftJoin('farmers', 'farmers.id', '=', 'agriculture_activities.farmer_id')
//                 // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//                 ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
//                 ->when($user_id, function ($query, $user_id) {
//                     // return $query->where('users.team_leader_id', $user_id);
//                     return $query->where('users.id', $user_id);
//                 });
            
//             if ($startDate && $endDate) 
//             {
//                 if ($startDate->eq($endDate)) {
//                     $dataQuery->whereDate('agriculture_activities.created_at', '=', $startDate);
//                 } else {
//                     $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
//                 }
//             } elseif ($startDate) {
//                 $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
//             } elseif ($endDate) {
//                 $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
//             } else {
//                 $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
//             }
//             $deshboard = 2;
//             $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
           
//             return view('Anexure.anexure-three', ['data' => $data,'deshboard'=>$deshboard]);
//         }
//         catch (\Throwable $th) {
//             return response()->json([
//                 'status' => false,
//                 'message' => $th->getMessage()
//             ], 500);
//         }
//   }
   
   
   // make four use 
   public function anexureThre33eUpdate(Request $request)
   {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            
            if ($request->isMethod('post')){   
                
                $id = $request->input('data_id');
                //dd($request->input());
                $agriculture_activities = [
                      "animal_name" => $request->input("animal_name_$id"),
                      "number" => $request->input("number_$id"),
                      "breed" => $request->input("breed_$id"),
                      "generation" => $request->input("generation_$id"),
                      "green_fodder" =>$request->input("green_fodder_$id"),
                      "green_fodder_quantity" =>$request->input("green_fodder_quantity_$id")." ".$request->input("green_fodder_quantity_unit_$id"),
                      "green_fodder_expenses" =>$request->input("green_fodder_expenses_$id")." ".$request->input("green_fodder_expenses_unit_$id"),
                      "dry_fodder_quantity" =>$request->input("dry_fodder_quantity_$id")." ".$request->input("dry_fodder_quantity_unit_$id"),
                      "dry_fodder_expenses" => $request->input("dry_fodder_expenses_$id")." ".$request->input("dry_fodder_expenses_unit_$id"),
                      "conventional_feed" => $request->input("conventional_feed_$id"),
                      "conventional_feed_quantity" => $request->input("conventional_feed_quantity_$id")." ".$request->input("conventional_feed_quantity_unit_$id"),
                      "conventional_feed_expenditure" => $request->input("conventional_feed_expenditure_$id")." ".$request->input("conventional_feed_quantity_unit_$id"),
                      "commercial_feed" => $request->input("commercial_feed_$id"),
                      "commercial_feed_quantity" => $request->input("commercial_feed_quantity_$id")." ".$request->input("commercial_feed_quantity_unit_$id"),
                      "commercial_feed_expenses" => $request->input("commercial_feed_expenses_$id")." ".$request->input("commercial_feed_quantity_unit_$id"),
                      "local" =>$request->input("local_$id"),
                      "branded" => $request->input("branded_$id"),
                      "health_expenditure" => $request->input("health_expenditure_$id")." ".$request->input("health_expenditure_unit_$id"),
                      "veterinary_distance" => $request->input("veterinary_distance_$id")." ".$request->input("veterinary_distance_unit_$id"),
                      "veterinary_quality" => $request->input("veterinary_quality_$id"),
                      "product" => $request->input("product_$id"),
                      "main_product_production" => $request->input("main_product_production_$id")." ".$request->input("main_product_production_unit_$id"),
                      "quantity_selling_market" => $request->input("quantity_selling_market_$id"),
                      "average_selling_price" => $request->input("average_selling_price_$id"),
                      "other_product_production" => $request->input("other_product_production_$id")." ".$request->input("other_product_production_unit_$id"),
                      "quantity_selling_other" => $request->input("quantity_selling_other_$id")." ".$request->input("quantity_selling_other_unit_$id"),
                      "average_selling_other" => $request->input("average_selling_other_$id"),
                      "first_sale_place" => $request->input("first_sale_place_$id"),
                      "who_purchase" => $request->input("who_purchase_$id"),
                      "unit_price_produce" => $request->input("unit_price_produce_$id"),
                      "under_weighing" => $request->input("under_weighing_$id"),
                      "trader_default" => $request->input("trader_default_$id"),
                      
                      "sold_to_villagers" => $request->input("sold_to_villagers_$id"),
                      "sold_to_milkman" => $request->input("sold_to_milkman_$id"),
                      "sold_to_local_dairy_unit" => $request->input("sold_to_local_dairy_unit_$id"),
                      "milk_processing_company" => $request->input("milk_processing_company_$id"),
                      "milk_cooperative_society" => $request->input("milk_cooperative_society_$id"),
                      "direct_sel_loc_mark" => $request->input("direct_sel_loc_mark_$id"),
                      "sold_to_other" => $request->input("sold_to_other_$id"),
                      "post_production_losses" => $request->input("post_production_losses_$id"),
                      "any_other_factors" => $request->input("any_other_factors_$id"),

                      
                      
                ];
                //dd($agriculture_activities);
                if ($id && !empty($agriculture_activities)) {
                    DB::table('agriculture_activities')->where('id', $id)->update($agriculture_activities);
                }
            }
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('agriculture_activities')
                ->select(
                    'agriculture_activities.*', 
                    'users.farmer_code_id'
                    // 'farmers.*',
                    // 'users.team_leader_id',
                    // 'agriculture_activities.id as id'
                )
                // ->leftJoin('farmers', 'farmers.id', '=', 'agriculture_activities.farmer_id')
                // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
                ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    // return $query->where('users.team_leader_id', $user_id);
                    return $query->where('users.id', $user_id);
                });
            
            if ($startDate && $endDate) 
            {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('agriculture_activities.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
            
            return view('Anexure.anexure-three-update', ['data' => $data]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
   
   
   
   
   public function updateAnnexureFour1Status(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'backward_link_id'   => $id,
            'status'    => $status
        ], [
            'backward_link_id'   =>  'required|exists:backward_linkages,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.four',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            BackwardLinkage::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.four',['date' => $date])->with('success','Annexure four Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    public function updateAnnexureFour2Status(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'forward_link_id'   => $id,
            'status'    => $status
        ], [
            'forward_link_id'   =>  'required|exists:forward_linkages,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.four',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            ForwardLinkage::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.four',['date' => $date])->with('success','Annexure four Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    
 public function four_list(Request $request)
  {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
             
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('agriculture_activities')
                ->select(
                    'agriculture_activities.*', 
                    'users.farmer_code_id',
                    'users.first_name as farmer_first_name',
                    'users.last_name as farmer_last_name'
                )
                ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.id', $user_id);
                });
            
            if ($startDate && $endDate) 
            {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('agriculture_activities.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
          
            return view('Anexure.anexure-four', ['data' => $data,'deshboard'=>$deshboard]);
        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
  }
    
    
//   public function four_list(Request $request)
//   {
       
//         $userAuth = Auth::user();
//         $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
//         try{
//             $startDate = $request->input('start_date');
//             $endDate = $request->input('end_date');
            
//             // Ensure the dates are in 'Y-m-d' format
//             if ($startDate) {
//                 $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
//             }
//             if ($endDate) {
//                 $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
//             }
            
//             $dataQuery = DB::table('forward_linkages')
//                 ->select(
//                     'forward_linkages.*',
//                     // 'farmers.*',
//                     'users.team_leader_id',
//                     'users.farmer_code_id',
//                     // 'users.*',
//                     'forward_linkages.id as id'
//                 )
//                 // ->leftJoin('farmers', 'farmers.id', '=', 'forward_linkages.farmer_id')
//                 // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//                 ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
//                 ->when($user_id, function ($query, $user_id) {
//                     // return $query->where('users.team_leader_id', $user_id);
//                     return $query->where('users.id', $user_id);
//                 });
                
//             if ($startDate && $endDate) {
//                 if ($startDate->eq($endDate)) {
//                     $dataQuery->whereDate('forward_linkages.created_at', '=', $startDate);
//                 } else {
//                     $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
//                 }
//             } elseif ($startDate) {
//                 $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
//             } elseif ($endDate) {
//                 $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
//             } else {
//                 $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
//             }
            
//             $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);
            
//             $dataQuery2 = DB::table('backward_linkages')
//                 ->select(
//                     'backward_linkages.*',
//                     'backward_linkages.id as id'
//                 )->when($user_id, function ($query, $user_id) {
//                     // return $query->where('users.team_leader_id', $user_id);
//                     return $query->where('backward_linkages.farmer_id', $user_id);
//                 });
            
//             if ($startDate && $endDate) {
//                 if ($startDate->eq($endDate)) {
//                     $dataQuery2->whereDate('backward_linkages.created_at', '=', $startDate);
//                 } else {
//                     $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
//                 }
//             } elseif ($startDate) {
//                 $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
//             } elseif ($endDate) {
//                 $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
//             } else {
//                 $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
//             }
            
//             $data2 = $dataQuery2->orderBy('backward_linkages.farmer_id', 'DESC')->paginate(15);
            
//             $dataQuery3 = DB::table('backward_linkage_twos')
//                 ->select(
//                     'backward_linkage_twos.*', 
//                     // 'farmers.*', 
//                     'users.team_leader_id'
//                 )
//                 // ->leftJoin('farmers', 'farmers.id', '=', 'backward_linkage_twos.farmer_id')
//                 // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
//                 ->leftJoin('users', 'users.id', '=', 'backward_linkage_twos.farmer_id')
//                 ->when($user_id, function ($query, $user_id) {
//                     // return $query->where('users.team_leader_id', $user_id);
//                     return $query->where('users.id', $user_id);
//                 });
                
//             if ($startDate && $endDate) {
//                 if ($startDate->eq($endDate)) {
//                     $dataQuery3->whereDate('backward_linkage_twos.created_at', '=', $startDate);
//                 } else {
//                     $dataQuery3->whereBetween('backward_linkage_twos.created_at', [$startDate, $endDate]);
//                 }
//             } elseif ($startDate) {
//                 $dataQuery3->whereDate('backward_linkage_twos.created_at', '>=', $startDate);
//             } elseif ($endDate) {
//                 $dataQuery3->whereDate('backward_linkage_twos.created_at', '<=', $endDate);
//             } else {
//                 $dataQuery3->whereDate('backward_linkage_twos.created_at', '=', \Carbon\Carbon::today());
//             }
//             $deshboard = 2;
//             $data3 = $dataQuery3->orderBy('backward_linkage_twos.farmer_id', 'DESC')->paginate(15);
            
//             return view('Anexure.anexure-four', ['data' => $data, 'data2' => $data2, 'data3' => $data3,'deshboard'=>$deshboard]);

//         }
//         catch (\Throwable $th) {
//             return response()->json([
//                 'status' => false,
//                 'message' => $th->getMessage()
//             ], 500);
//         }
//   }


    public function anexureFourUpdate(Request $request){
     $userAuth = Auth::user();
     $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
    
        try{
            if ($request->isMethod('post')){   
               // dd($request->all());
                
                $id = $request->input('id');
                $farmerid = $request->input('farmarid');
                
                $green_fodder_data = $request->green_fodder_quantity_value;
                $green_fodder_value = $request->green_fodder_quantity_unit;
                $green_fodder_combined = $green_fodder_data . ' ' . $green_fodder_value;
                
                $green_fodder_expenses_unit = $request->green_fodder_expenses_unit;
                $green_fodder_expenses_value = $request->green_fodder_expenses_value;
                $green_fodder_expenses_combined = $green_fodder_expenses_value . ' ' . $green_fodder_expenses_unit;
                
                $dry_fodder_quantity_combined = $request->dry_fodder_quantity_value . ' ' . $request->dry_fodder_quantity_unit;
                
                
                
                $commercial_feed_quantity_combined = $request->commercial_feed_quantity_value . ' ' . $request->commercial_feed_quantity_unit;
                
                $health_expenditure_combined = $request->health_expenditure_value . ' ' . $request->health_expenditure_unit;
                
                $veterinary_distance_combined = $request->veterinary_distance_value . ' ' . $request->veterinary_distance_unit;
                
                $main_product_production_combined = $request->main_product_production_value . ' ' . $request->main_product_production_unit;
                
                $rs = $request->rs;
                
                $quantity_selling_market_combined = $request->quantity_selling_market_value . ' ' . $request->quantity_selling_market_unit;
                    
                AgricultureActivity::where('id',$id)->where('farmer_id',$farmerid)->update([
                        
                        "number" => $request->input("number"),
                        "animal_name" => $request->input("animal_name"),
                        "breed" => $request->input("breed"),
                        "generation" => $request->input("generation"),
                        "green_fodder" => $request->input("green_fodder"),
                        "green_fodder_quantity" => $green_fodder_combined,
                        "green_fodder_expenses" => $green_fodder_expenses_combined,
                        "dry_feed" =>$request->input("dry_feed"),
                        "dry_fodder_quantity" => $dry_fodder_quantity_combined,
                        "dry_fodder_expenses" => $request->input("dry_fodder_expenses") . ' ' . $rs,
                        "commercial_feed" => $request->input("commercial_feed"),
                        "commercial_feed_quantity" => $commercial_feed_quantity_combined,
                        "conventional_feed_expenditure" => $request->input("conventional_feed_expenditure") . ' ' . $rs,
                        "commercial_feed_expenses" => $request->input("commercial_feed_expenses") . ' ' . $rs,
                        "local" => $request->input("local"),
                        "branded" => $request->input("branded"),
                        "health_expenditure" => $health_expenditure_combined,
                        "veterinary_distance" => $veterinary_distance_combined,
                        "veterinary_quality" => $request->input("veterinary_quality"),
                        "product" => $request->input("product"),
                        "main_product_production" => $main_product_production_combined,
                        "quantity_selling_market" => $request->input("quantity_selling_market"),
                        "average_selling_price" => $request->input("average_selling_price") . ' ' . $rs,
                        "other_product_production" => $request->input("other_product_production"),
                        "average_selling_other" => $request->input("average_selling_other") . ' ' . $rs,
                        "avarage_lactetation_period_unit" => $request->input("avarage_lactetation_period_unit"),
                        
                         "quantity_selling_market" => $quantity_selling_market_combined,
                        
                        
                        "avarage_lactetation_period" => $request->input("avarage_lactetation_period"),
                        "first_sale_place" => $request->input("first_sale_place"),
                        
                        "sold_to_villagers" => $request->input("sold_to_villagers"),
                        "sold_to_milkman" => $request->input("sold_to_milkman"),
                         "sold_to_local_dairy_unit" => $request->input("sold_to_local_dairy_unit"),
                         "milk_processing_company" => $request->input("milk_processing_company"),
                         "milk_cooperative_society" => $request->input("milk_cooperative_society"),
                        "sold_to_other" => $request->input("sold_to_other"),
                        "under_weighing" => $request->input("under_weighing"),
                        "trader_default" => $request->input("trader_default"),
                        "post_production_losses" => $request->input("post_production_losses"),
                        "any_other_factors" => $request->input("any_other_factors"),
                        "direct_sel_loc_mark" => $request->input("direct_sel_loc_mark")
                ]);
                 $request->session()->flash('success', "Update Sucessfull");
                 return back();
               
            }
            
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
         
        if ($startDate) {
            $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
        }
        if ($endDate) {
            $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
        }
        
        $dataQuery = DB::table('agriculture_activities')
            ->select(
                'agriculture_activities.*', 
                'users.farmer_code_id',
                'users.first_name as farmer_first_name',
                'users.last_name as farmer_last_name'
            )
            ->leftJoin('users', 'users.id', '=', 'agriculture_activities.farmer_id')
            ->when($user_id, function ($query, $user_id) {
                return $query->where('users.id', $user_id);
            });
        
        if ($startDate && $endDate) 
        {
            if ($startDate->eq($endDate)) {
                $dataQuery->whereDate('agriculture_activities.created_at', '=', $startDate);
            } else {
                $dataQuery->whereBetween('agriculture_activities.created_at', [$startDate, $endDate]);
            }
        } elseif ($startDate) {
            $dataQuery->whereDate('agriculture_activities.created_at', '>=', $startDate);
        } elseif ($endDate) {
            $dataQuery->whereDate('agriculture_activities.created_at', '<=', $endDate);
        } else {
            $dataQuery->whereDate('agriculture_activities.created_at', '=', \Carbon\Carbon::today());
        }
        $deshboard = 2;
        $data = $dataQuery->orderBy('agriculture_activities.id', 'DESC')->paginate(15);
      
        return view('Anexure.anexure-four-update', ['data' => $data,'deshboard'=>$deshboard]);
           
        }
    
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }




   
   // make any four to five change
    public function anexureFourUpdateChange(Request $request){
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            if ($request->isMethod('post')){   
                //dd($request->input());
                $id = $request->input('data_id');
                $form = $request->input('backward');
                if($form==1){
                    $backward = [
                      "particular_name" => $request->input("particular_name_$id"),
                      "input_supplier_name" => $request->input("input_supplier_name_$id"),
                      "input_supplier_phone" => $request->input("input_supplier_phone_$id"),
                      "adequacy" => $request->input("adequacy_$id"),
                      "quality" => $request->input("quality_$id"),
                      "timely_supply" => $request->input("timely_supply_$id"),
                      "effectiveness" => $request->input("effectiveness_$id"),
                      "as_consultancy_service" => $request->input("as_consultancy_service_$id"),
                      "price_reasonability" => $request->input("price_reasonability_$id"),
                      "with_or_without_credit" =>$request->input("with_or_without_credit_$id"),
                      "diff_in_price_with_without_credit" =>$request->input("diff_in_price_with_without_credit_$id"),
                      "remark" => $request->input("remark_$id")
                    ];
                    if ($id && !empty($backward)) {
                        DB::table('backward_linkages')->where('id', $id)->update($backward);
                    }
                }elseif($form==2){
                    $backward2 = [
                        "seed_type" => $request->input("seed_type_two_$id"),
                        "distance_from_farm_unit" => $request->input("distance_from_farm_unit_two_$id"),
                        "labour" => $request->input("labour_two_$id"),
                        "fuel_electricity_source" => $request->input("fuel_electricity_source_two_$id"),
                        "technology_transfer" => $request->input("technology_transfer_two_$id")
                    ];
                    
                    if ($id && !empty($backward2)) {
                        DB::table('backward_linkage_twos')->where('id', $id)->update($backward2);
                    }
                }elseif($form==3){
                    $req = $request->input();
                    $json = [
                        "unit"=>'',
                        "value"=>'',
                        "farm_gate"=>'',
                        "msp"=>'',
                        "village_trader"=>'',
                        "mandi"=>'',
                        "processor"=>'',
                        "distributor"=>'',
                        "retailer"=>'',
                        "consumer"=>''
                    ];
                    $forwardlink = [
                        "marketing_channel"=>[],
                        "marketing_channel_distance"=>[],
                        "transportation_method"=>[],
                        "transport_by"=>[],
                        "transport_expenses"=>[],
                        "primary_processing"=>[],
                        "buyer_institution_present"=>[],
                        "formal_informal_contract"=>[],
                        "niche_market"=>[],
                        "secondary_processing"=>[],
                        "processing_in_vicinity"=>[],
                        "storage_facility"=>[],
                        "storage"=>[],
                        "facility_capacity"=>[],
                        "storage_charges"=>[],
                        "time_of_sale"=>[],
                        "road_connectivity"=>[],
                        "payment_of_sale"=>[],
                        "total_sale_value"=>[],
                        "weighing_method"=>[],
                        "extent_of_under_weighing"=>[],
                        "source_of_market_info"=>[],
                        "total_marketable_surplus"=>[],
                        "selling_on_msp"=>[],
                        "extent_of_msp_price"=>[],
                        "remark"=>[]
                    ];
                    
                    foreach($json as $jk=>$jv){
                               
                        foreach($forwardlink as $k=>$fv){
                            $forwardlink[$k][$jk] = '';
                         
                        }
                                
                                
                    }
                    
                    
                    foreach($req as $key=>$val){
 
                        
                        if(is_array($val)){
                            
                            foreach($json as $jk=>$jv){
                                $idx =0;
                                foreach($forwardlink as $k=>$fv){
                                    if($jk."_".$id==$key){
                                     $forwardlink[$k][$jk] = $val[$idx];
                                    }                                 
                                    $idx++;
                                 
                                }
                                
                            }
                            
                        }
                        
                    }
                    //dd($forwardlink);
                    
                    
                    
                    
                }
                
                
                
                foreach($forwardlink as $fk=>$fv){
                    $forwardlink[$fk] = json_encode($forwardlink[$fk]);
                    
                }
                
                
                if ($id && !empty($forwardlink)) {
                        DB::table('forward_linkages')->where('id', $id)->update($forwardlink);
                }
                
            }
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            // Ensure the dates are in 'Y-m-d' format
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('forward_linkages')
                ->select(
                    'forward_linkages.*',
                    // 'farmers.*',
                    'users.team_leader_id',
                    'users.farmer_code_id',
                    // 'users.*',
                    'forward_linkages.id as id'
                )
                // ->leftJoin('farmers', 'farmers.id', '=', 'forward_linkages.farmer_id')
                // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
                ->leftJoin('users', 'users.id', '=', 'forward_linkages.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    // return $query->where('users.team_leader_id', $user_id);
                    return $query->where('users.id', $user_id);
                });
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('forward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('forward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('forward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('forward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('forward_linkages.farmer_id', 'DESC')->paginate(15);
            // dd($userAuth);
            $dataQuery2 = DB::table('backward_linkages')
                ->select(
                    'backward_linkages.*',
                    'backward_linkages.id as id'
                )->when($user_id, function ($query, $user_id) {
                    // return $query->where('users.team_leader_id', $user_id);
                    return $query->where('backward_linkages.farmer_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery2->whereDate('backward_linkages.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('backward_linkages.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('backward_linkages.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('backward_linkages.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data2 = $dataQuery2->orderBy('backward_linkages.farmer_id', 'DESC')->paginate(15);
            
            $dataQuery3 = DB::table('backward_linkage_twos')
                ->select(
                    'backward_linkage_twos.*', 
                    // 'farmers.*', 
                    'users.team_leader_id'
                )
                // ->leftJoin('farmers', 'farmers.id', '=', 'backward_linkage_twos.farmer_id')
                // ->leftJoin('users', 'users.id', '=', 'farmers.user_id')
                ->leftJoin('users', 'users.id', '=', 'backward_linkage_twos.farmer_id')
                ->when($user_id, function ($query, $user_id) {
                    // return $query->where('users.team_leader_id', $user_id);
                    return $query->where('users.id', $user_id);
                });
                
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery3->whereDate('backward_linkage_twos.created_at', '=', $startDate);
                } else {
                    $dataQuery3->whereBetween('backward_linkage_twos.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery3->whereDate('backward_linkage_twos.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery3->whereDate('backward_linkage_twos.created_at', '<=', $endDate);
            } else {
                $dataQuery3->whereDate('backward_linkage_twos.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data3 = $dataQuery3->orderBy('backward_linkage_twos.farmer_id', 'DESC')->paginate(15);
            
            return view('Anexure.anexure-four-update', ['data' => $data, 'data2' => $data2, 'data3' => $data3]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
    public function updateAnnexureFiveStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'input_supp_id'   => $id,
            'status'    => $status
        ], [
            'input_supp_id'   =>  'required|exists:input_suppliers,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.five',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            InputSupplier::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.five',['date' => $date])->with('success','Annexure five Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
   
   public function five_list(Request $request)
   {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('input_suppliers')
                ->select(
                    'input_suppliers.*', 
                    // 'farmers.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id'
                    // 'input_suppliers.id as id'
                )
                // ->leftJoin('farmers', 'farmers.id', '=', 'input_suppliers.user_id')
                ->leftJoin('users', 'input_suppliers.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->eq($endDate)) {
                    $dataQuery->whereDate('input_suppliers.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('input_suppliers.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('input_suppliers.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('input_suppliers.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('input_suppliers.created_at', '=', \Carbon\Carbon::today());
            }
            
            $perYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Permanent')
            ->where('economic_life_name','INPUT SHOP PERMANENT')
            ->first();
            
            $stogest = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost Storage Structure for Inputs')
            ->where('economic_life_name','STORAGE GODOWN')
            ->first();
            
            $tempYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Temporary')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
            
            $monthElectricity = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Monthly Expenses on Electricity')
            ->where('economic_life_name','ELECTRICITY INSTALLATION')->select('year')
            ->first();
            
            $computerasso = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','COMPUTER & ELECTRONIC ASSOCERIES')
            ->where('economic_life_name','COMPUTER & ELECTRONIC ASSOCERIES')->select('year')
            ->first();
            
            $plant = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','PLANT & MACHINARY')
            ->where('economic_life_name','PLANT & MACHINARY')->select('year')
            ->first();
            
            $electricmoter = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','ELECTRIC MOTOR')
            ->where('economic_life_name','ELECTRIC MOTOR')->select('year')
            ->first();
            
            $disealengine = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','DISEAL ENGINE')
            ->where('economic_life_name','DISEAL ENGINE')->select('year')
            ->first();
            
            $tractorda = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','TRACTOR')
            ->where('economic_life_name','TRACTOR')->select('year')
            ->first();
            
            $deshboard = 2;
            $data = $dataQuery->orderBy('input_suppliers.user_id', 'DESC')->paginate(15);
            
            return view('Anexure.anexure-five', ['data' => $data,'deshboard'=>$deshboard ,'perYear'=>$perYear , 'stogest'=>$stogest , 'tempYear'=>$tempYear,
            'monthElectricity'=>$monthElectricity, 'computerasso'=>$computerasso , 'plant'=>$plant , 'electricmoter'=>$electricmoter, 'disealengine'=>$disealengine,
            'tractorda'=>$tractorda]);

        }
        catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
    }
    
    public function updateAnnexureSixStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'caph_farms_id'   => $id,
            'status'    => $status
        ], [
            'caph_farms_id'   =>  'required|exists:caph_farms,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.six',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            CaphFarm::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.six',['date' => $date])->with('success','Annexure six Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    public function six_list(Request $request)
    {    
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('caph_farms')
                ->select(
                    'caph_farms.*', 
                    'users.team_leader_id',
                     'users.first_name',
                     'users.last_name',
                     'users.farmer_code_id',
                    'caph_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'caph_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('caph_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('caph_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('caph_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('caph_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('caph_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;

            $data = $dataQuery->orderBy('caph_farms.user_id', 'DESC')->paginate(15);
            
            $perYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Permanent')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Temporary')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
           
           $monthElectricity = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Monthly Expenses on Electricity')
            ->where('economic_life_name','ELECTRICITY INSTALLATION')->select('year')
            ->first();
            
            $coststorage = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost Storage Structure for Inputs')
            ->where('economic_life_name','STORAGE GODOWN')->select('year')
            ->first();
           
            return view('Anexure.anexure-six', ['data' => $data,'deshboard'=>$deshboard , 'perYear'=>$perYear , 'tempYear'=>$tempYear,
            'monthElectricity'=>$monthElectricity , 'coststorage'=>$coststorage]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
    public function AnexureSixUpdate(Request $request)
    {    
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            
           if ($request->isMethod('post')) 
           {
               dd($request->all());
           }
            
            
            
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('caph_farms')
                ->select(
                    'caph_farms.*', 
                    'users.team_leader_id',
                     'users.first_name',
                     'users.last_name',
                     'users.farmer_code_id',
                    'caph_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'caph_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('caph_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('caph_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('caph_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('caph_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('caph_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;

            $data = $dataQuery->orderBy('caph_farms.user_id', 'DESC')->paginate(15);
            
            $perYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Permanent')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost of establishment of Input Shop Temporary')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
           
           $monthElectricity = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Monthly Expenses on Electricity')
            ->where('economic_life_name','ELECTRICITY INSTALLATION')->select('year')
            ->first();
            
            $coststorage = economic_life_farm_assets_master::where('form_name','Anexure Supplier II')->where('field_name','Cost Storage Structure for Inputs')
            ->where('economic_life_name','STORAGE GODOWN')->select('year')
            ->first();
           
            return view('Anexure.anexure-six-update', ['data' => $data,'deshboard'=>$deshboard , 'perYear'=>$perYear , 'tempYear'=>$tempYear,
            'monthElectricity'=>$monthElectricity , 'coststorage'=>$coststorage]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
    public function updateAnnexureSevenStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'trd_farms_id'   => $id,
            'status'    => $status
        ], [
            'trd_farms_id'   =>  'required|exists:trd_farms,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.seven',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            TrdFarm::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.seven',['date' => $date])->with('success','Annexure seven Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
   public function seven_list(Request $request)
   {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
       try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('trd_farms')
                ->select(
                    'trd_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'trd_farms.id as id'
                )
                ->leftJoin('users', 'trd_farms.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('trd_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('trd_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('trd_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('trd_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('trd_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data = $dataQuery->orderBy('trd_farms.user_id', 'DESC')->paginate(15);
            
             $perYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Parmanant')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Temparory')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
          
            return view('Anexure.anexure-seven', ['data' => $data,'deshboard'=>$deshboard , 'perYear'=>$perYear,'tempYear'=>$tempYear]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
    public function updateAnnexureEightOneStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'va_one_farms_id'   => $id,
            'status'    => $status
        ], [
            'va_one_farms_id'   =>  'required|exists:va_one_farms,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.eight',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            VaOneFarm::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.eight',['date' => $date])->with('success','Annexure eight Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    public function updateAnnexureEightTwoStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'va_two_farms_id'   => $id,
            'status'    => $status
        ], [
            'va_two_farms_id'   =>  'required|exists:va_two_farms,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.eight',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            VaTwoFarm::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.eight',['date' => $date])->with('success','Annexure eight Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
    public function updateAnnexureEightThreeStatus(Request $request, $id, $status)
    {
        $validate = Validator::make([
            'va_three_farms_id'   => $id,
            'status'    => $status
        ], [
            'va_three_farms_id'   =>  'required|exists:va_three_farms,id',
            'status'    =>  'required|in:0,1',
        ]);
        if($validate->fails()){
            return redirect()->route('anexure.eight',['date' => $date])->with('error', $validate->errors()->first());
        }
        try {
            DB::beginTransaction();
            VaThreeFarm::whereId($id)->update(['status' => $status]);
            DB::commit();
            return redirect()->route('anexure.eight',['date' => $date])->with('success','Annexure eight Status Updated Successfully!');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->with('error', $th->getMessage());
        }
    }
    
   public function eight_list(Request $request)
   {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
        try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('va_one_farms')
                ->select(
                    'va_one_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_one_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'va_one_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('va_one_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('va_one_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('va_one_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('va_one_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('va_one_farms.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data = $dataQuery->orderBy('va_one_farms.user_id', 'DESC')->paginate(15);
           
            $dataQuery1 = DB::table('va_two_farms')
                ->select(
                    'va_two_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_two_farms.id as id'
                )
                ->leftJoin('users', 'va_two_farms.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery1->whereDate('va_two_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery1->whereBetween('va_two_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery1->whereDate('va_two_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery1->whereDate('va_two_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery1->whereDate('va_two_farms.created_at', '=', \Carbon\Carbon::today());
            }
            
            $data1 = $dataQuery1->orderBy('va_two_farms.user_id', 'DESC')->paginate(15);
          
            $dataQuery2 = DB::table('va_three_farms')
                ->select(
                    'va_three_farms.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'users.team_leader_id',
                    'va_three_farms.id as id'
                )
                ->leftJoin('users', 'users.id', '=', 'va_three_farms.user_id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
            
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery2->whereDate('va_three_farms.created_at', '=', $startDate);
                } else {
                    $dataQuery2->whereBetween('va_three_farms.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery2->whereDate('va_three_farms.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery2->whereDate('va_three_farms.created_at', '<=', $endDate);
            } else {
                $dataQuery2->whereDate('va_three_farms.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data2 = $dataQuery2->orderBy('va_three_farms.user_id', 'DESC')->paginate(15);
           
            return view('Anexure.anexure-eight', ['data' => $data, 'data1' => $data1, 'data2' => $data2,'deshboard'=>$deshboard]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
   public function fpo_a(Request $request)
   {
       
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
       try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('fpoa_masters')
                ->select(
                    'fpoa_masters.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'fpoa_masters.id as id'
                )
                ->leftJoin('users', 'fpoa_masters.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('fpoa_masters.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('fpoa_masters.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('fpoa_masters.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('fpoa_masters.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('fpoa_masters.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data = $dataQuery->orderBy('fpoa_masters.id', 'DESC')->paginate(15);
            
            return view('Anexure.fpo-a', ['data' => $data,'deshboard'=>$deshboard]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
   public function fpo_b(Request $request)
   {
       
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
       try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('fpob_masters')
                ->select(
                    'fpob_masters.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'fpob_masters.id as id'
                )
                ->leftJoin('users', 'fpob_masters.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('fpob_masters.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('fpob_masters.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('fpob_masters.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('fpob_masters.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('fpob_masters.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data = $dataQuery->orderBy('fpob_masters.user_id', 'DESC')->paginate(15);
          
            return view('Anexure.fpo-b', ['data' => $data,'deshboard'=>$deshboard]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
   public function anexure_distributor(Request $request)
   {
        $userAuth = Auth::user();
        $user_id = ($userAuth['id'] != 1) ? $userAuth['id'] : null;
        
       try{
            $startDate = $request->input('start_date');
            $endDate = $request->input('end_date');
            
            if ($startDate) {
                $startDate = \Carbon\Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
            }
            if ($endDate) {
                $endDate = \Carbon\Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
            }
            
            $dataQuery = DB::table('distributors')
                ->select(
                    'distributors.*', 
                    'users.first_name',
                    'users.last_name',
                    'users.farmer_code_id',
                    'distributors.id as id'
                )
                ->leftJoin('users', 'distributors.user_id', '=', 'users.id')
                ->when($user_id, function ($query, $user_id) {
                    return $query->where('users.team_leader_id', $user_id);
                });
           
            if ($startDate && $endDate) {
                if ($startDate->equalTo($endDate)) {
                    $dataQuery->whereDate('distributors.created_at', '=', $startDate);
                } else {
                    $dataQuery->whereBetween('distributors.created_at', [$startDate, $endDate]);
                }
            } elseif ($startDate) {
                $dataQuery->whereDate('distributors.created_at', '>=', $startDate);
            } elseif ($endDate) {
                $dataQuery->whereDate('distributors.created_at', '<=', $endDate);
            } else {
                $dataQuery->whereDate('distributors.created_at', '=', \Carbon\Carbon::today());
            }
            $deshboard = 2;
            $data = $dataQuery->orderBy('distributors.user_id', 'DESC')->paginate(15);
            
            $perYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Parmanant')
            ->where('economic_life_name','INPUT SHOP PERMANENT')->select('year')
            ->first();
            
            
            $tempYear = economic_life_farm_assets_master::where('form_name','anexure-distributor')->where('field_name','Cost of Establishment Temparory')
            ->where('economic_life_name','INPUT SHOP TEMPARORY')->select('year')
            ->first();
            
            
            return view('Anexure.Anexure-distributor', ['data' => $data,'deshboard'=>$deshboard,'perYear'=>$perYear,'tempYear'=>$tempYear]);

       }
       catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ], 500);
        }
   }
   
   
    
   
}
